/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.messages;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputStickeredMedia;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.messages.GetAttachedStickers;

public final class ImmutableGetAttachedStickers
implements GetAttachedStickers {
    private final int identifier;
    private final InputStickeredMedia media;

    private ImmutableGetAttachedStickers(InputStickeredMedia media) {
        this.media = Objects.requireNonNull(media, "media");
        this.identifier = GetAttachedStickers.super.identifier();
    }

    private ImmutableGetAttachedStickers(Builder builder) {
        this.media = builder.media;
        this.identifier = builder.identifierIsSet() ? builder.identifier : GetAttachedStickers.super.identifier();
    }

    private ImmutableGetAttachedStickers(int identifier, InputStickeredMedia media) {
        this.identifier = identifier;
        this.media = media;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public InputStickeredMedia media() {
        return this.media;
    }

    public final ImmutableGetAttachedStickers withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableGetAttachedStickers(value, this.media);
    }

    public final ImmutableGetAttachedStickers withMedia(InputStickeredMedia value) {
        if (this.media == value) {
            return this;
        }
        InputStickeredMedia newValue = Objects.requireNonNull(value, "media");
        return new ImmutableGetAttachedStickers(this.identifier, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGetAttachedStickers && this.equalTo(0, (ImmutableGetAttachedStickers)another);
    }

    private boolean equalTo(int synthetic, ImmutableGetAttachedStickers another) {
        return this.identifier == another.identifier && this.media.equals(another.media);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.media.hashCode();
        return h;
    }

    public String toString() {
        return "GetAttachedStickers{identifier=" + this.identifier + ", media=" + this.media + "}";
    }

    public static ImmutableGetAttachedStickers of(InputStickeredMedia media) {
        return new ImmutableGetAttachedStickers(media);
    }

    public static ImmutableGetAttachedStickers copyOf(GetAttachedStickers instance) {
        if (instance instanceof ImmutableGetAttachedStickers) {
            return (ImmutableGetAttachedStickers)instance;
        }
        return ImmutableGetAttachedStickers.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_MEDIA = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private InputStickeredMedia media;

        private Builder() {
        }

        public final Builder from(GetAttachedStickers instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            GetAttachedStickers instance;
            long bits = 0L;
            if (object instanceof GetAttachedStickers) {
                instance = (GetAttachedStickers)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.media(instance.media());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder media(InputStickeredMedia media) {
            this.media = Objects.requireNonNull(media, "media");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableGetAttachedStickers build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableGetAttachedStickers(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("media");
            }
            return "Cannot build GetAttachedStickers, some of required attributes are not set " + attributes;
        }
    }
}

