/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.messages;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.messages.GetAvailableReactions;

public final class ImmutableGetAvailableReactions
implements GetAvailableReactions {
    private final int identifier;
    private final int hash;

    private ImmutableGetAvailableReactions(int hash) {
        this.hash = hash;
        this.identifier = GetAvailableReactions.super.identifier();
    }

    private ImmutableGetAvailableReactions(Builder builder) {
        this.hash = builder.hash;
        this.identifier = builder.identifierIsSet() ? builder.identifier : GetAvailableReactions.super.identifier();
    }

    private ImmutableGetAvailableReactions(int identifier, int hash) {
        this.identifier = identifier;
        this.hash = hash;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public int hash() {
        return this.hash;
    }

    public final ImmutableGetAvailableReactions withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableGetAvailableReactions(value, this.hash);
    }

    public final ImmutableGetAvailableReactions withHash(int value) {
        if (this.hash == value) {
            return this;
        }
        return new ImmutableGetAvailableReactions(this.identifier, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGetAvailableReactions && this.equalTo(0, (ImmutableGetAvailableReactions)another);
    }

    private boolean equalTo(int synthetic, ImmutableGetAvailableReactions another) {
        return this.identifier == another.identifier && this.hash == another.hash;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.hash;
        return h;
    }

    public String toString() {
        return "GetAvailableReactions{identifier=" + this.identifier + ", hash=" + this.hash + "}";
    }

    public static ImmutableGetAvailableReactions of(int hash) {
        return new ImmutableGetAvailableReactions(hash);
    }

    public static ImmutableGetAvailableReactions copyOf(GetAvailableReactions instance) {
        if (instance instanceof ImmutableGetAvailableReactions) {
            return (ImmutableGetAvailableReactions)instance;
        }
        return ImmutableGetAvailableReactions.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_HASH = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private int hash;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(GetAvailableReactions instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof GetAvailableReactions) {
                instance = (GetAvailableReactions)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.hash(instance.hash());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder hash(int hash) {
            this.hash = hash;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableGetAvailableReactions build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableGetAvailableReactions(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("hash");
            }
            return "Cannot build GetAvailableReactions, some of required attributes are not set " + attributes;
        }
    }
}

