/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.messages;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import reactor.util.annotation.Nullable;
import telegram4j.tl.InputCheckPasswordSRP;
import telegram4j.tl.InputPeer;
import telegram4j.tl.api.TlEncodingUtil;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.messages.GetBotCallbackAnswer;

public final class ImmutableGetBotCallbackAnswer
implements GetBotCallbackAnswer {
    private final int identifier;
    private final int flags;
    private final boolean game;
    private final InputPeer peer;
    private final int msgId;
    private final ByteBuf data;
    @Nullable
    private final InputCheckPasswordSRP password;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableGetBotCallbackAnswer(InputPeer peer, int msgId) {
        this.peer = Objects.requireNonNull(peer, "peer");
        this.msgId = msgId;
        this.data = null;
        this.password = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.game = this.initShim.game();
        this.initShim = null;
    }

    private ImmutableGetBotCallbackAnswer(Builder builder) {
        this.peer = builder.peer;
        this.msgId = builder.msgId;
        this.data = builder.data_build();
        this.password = builder.password;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.gameIsSet()) {
            this.initShim.game(builder.game);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.game = this.initShim.game();
        this.initShim = null;
    }

    private ImmutableGetBotCallbackAnswer(int identifier, int flags, boolean game, InputPeer peer, int msgId, ByteBuf data, @Nullable InputCheckPasswordSRP password) {
        this.identifier = identifier;
        this.flags = flags;
        this.game = game;
        this.peer = peer;
        this.msgId = msgId;
        this.data = data;
        this.password = password;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return GetBotCallbackAnswer.super.identifier();
    }

    private int flagsInitialize() {
        return GetBotCallbackAnswer.super.flags();
    }

    private boolean gameInitialize() {
        return GetBotCallbackAnswer.super.game();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean game() {
        InitShim shim = this.initShim;
        return shim != null ? shim.game() : this.game;
    }

    @Override
    public InputPeer peer() {
        return this.peer;
    }

    @Override
    public int msgId() {
        return this.msgId;
    }

    @Override
    public Optional<ByteBuf> data() {
        return Optional.ofNullable(this.data).map(ByteBuf::duplicate);
    }

    @Override
    @Nullable
    public InputCheckPasswordSRP password() {
        return this.password;
    }

    public final ImmutableGetBotCallbackAnswer withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableGetBotCallbackAnswer(value, this.flags, this.game, this.peer, this.msgId, this.data, this.password);
    }

    public final ImmutableGetBotCallbackAnswer withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableGetBotCallbackAnswer(this.identifier, value, this.game, this.peer, this.msgId, this.data, this.password);
    }

    public final ImmutableGetBotCallbackAnswer withGame(boolean value) {
        if (this.game == value) {
            return this;
        }
        return new ImmutableGetBotCallbackAnswer(this.identifier, this.flags, value, this.peer, this.msgId, this.data, this.password);
    }

    public final ImmutableGetBotCallbackAnswer withPeer(InputPeer value) {
        if (this.peer == value) {
            return this;
        }
        InputPeer newValue = Objects.requireNonNull(value, "peer");
        return new ImmutableGetBotCallbackAnswer(this.identifier, this.flags, this.game, newValue, this.msgId, this.data, this.password);
    }

    public final ImmutableGetBotCallbackAnswer withMsgId(int value) {
        if (this.msgId == value) {
            return this;
        }
        return new ImmutableGetBotCallbackAnswer(this.identifier, this.flags, this.game, this.peer, value, this.data, this.password);
    }

    public ImmutableGetBotCallbackAnswer withData(Optional<ByteBuf> value) {
        ByteBuf newValue = value.map(TlEncodingUtil::copyAsUnpooled).orElse(null);
        if (this.data == newValue) {
            return this;
        }
        return new ImmutableGetBotCallbackAnswer(this.identifier, this.flags, this.game, this.peer, this.msgId, newValue, this.password);
    }

    public ImmutableGetBotCallbackAnswer withData(ByteBuf value) {
        ByteBuf newValue = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
        if (this.data == newValue) {
            return this;
        }
        return new ImmutableGetBotCallbackAnswer(this.identifier, this.flags, this.game, this.peer, this.msgId, newValue, this.password);
    }

    public final ImmutableGetBotCallbackAnswer withPassword(@Nullable InputCheckPasswordSRP value) {
        if (this.password == value) {
            return this;
        }
        return new ImmutableGetBotCallbackAnswer(this.identifier, this.flags, this.game, this.peer, this.msgId, this.data, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGetBotCallbackAnswer && this.equalTo(0, (ImmutableGetBotCallbackAnswer)another);
    }

    private boolean equalTo(int synthetic, ImmutableGetBotCallbackAnswer another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.game == another.game && this.peer.equals(another.peer) && this.msgId == another.msgId && this.data().equals(another.data()) && Objects.equals(this.password, another.password);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.game);
        h += (h << 5) + this.peer.hashCode();
        h += (h << 5) + this.msgId;
        h += (h << 5) + this.data().hashCode();
        h += (h << 5) + Objects.hashCode(this.password);
        return h;
    }

    public String toString() {
        return "GetBotCallbackAnswer{identifier=" + this.identifier + ", flags=" + this.flags + ", game=" + this.game + ", peer=" + this.peer + ", msgId=" + this.msgId + ", data=" + this.data().map(ByteBufUtil::hexDump).toString() + ", password=" + this.password + "}";
    }

    public static ImmutableGetBotCallbackAnswer of(InputPeer peer, int msgId) {
        return new ImmutableGetBotCallbackAnswer(peer, msgId);
    }

    public static ImmutableGetBotCallbackAnswer copyOf(GetBotCallbackAnswer instance) {
        if (instance instanceof ImmutableGetBotCallbackAnswer) {
            return (ImmutableGetBotCallbackAnswer)instance;
        }
        return ImmutableGetBotCallbackAnswer.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PEER = 1L;
        private static final long INIT_BIT_MSG_ID = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_GAME = 4L;
        private long initBits = 3L;
        private long optBits;
        private ByteBuf data_value = null;
        private int identifier;
        private int flags;
        private boolean game;
        private InputPeer peer;
        private int msgId;
        private InputCheckPasswordSRP password;

        private Builder() {
        }

        public final Builder from(GetBotCallbackAnswer instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            GetBotCallbackAnswer instance;
            long bits = 0L;
            if (object instanceof GetBotCallbackAnswer) {
                instance = (GetBotCallbackAnswer)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.game(instance.game());
                InputCheckPasswordSRP passwordValue = instance.password();
                if (passwordValue != null) {
                    this.password(passwordValue);
                }
                this.data(instance.data());
                this.peer(instance.peer());
                this.flags(instance.flags());
                this.msgId(instance.msgId());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder game(boolean game) {
            this.game = game;
            this.optBits |= 4L;
            return this;
        }

        public final Builder peer(InputPeer peer) {
            this.peer = Objects.requireNonNull(peer, "peer");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder msgId(int msgId) {
            this.msgId = msgId;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public Builder data(@Nullable ByteBuf value) {
            this.data_value = value != null ? TlEncodingUtil.copyAsUnpooled((ByteBuf)value) : null;
            return this;
        }

        public Builder data(Optional<ByteBuf> value) {
            this.data_value = value.map(TlEncodingUtil::copyAsUnpooled).orElse(null);
            return this;
        }

        public final Builder password(@Nullable InputCheckPasswordSRP password) {
            this.password = password;
            return this;
        }

        public ImmutableGetBotCallbackAnswer build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableGetBotCallbackAnswer(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean gameIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("peer");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("msgId");
            }
            return "Cannot build GetBotCallbackAnswer, some of required attributes are not set " + attributes;
        }

        private ByteBuf data_build() {
            return this.data_value;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte gameBuildStage = 0;
        private boolean game;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableGetBotCallbackAnswer.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableGetBotCallbackAnswer.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean game() {
            if (this.gameBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.gameBuildStage == 0) {
                this.gameBuildStage = (byte)-1;
                this.game = ImmutableGetBotCallbackAnswer.this.gameInitialize();
                this.gameBuildStage = 1;
            }
            return this.game;
        }

        void game(boolean game) {
            this.game = game;
            this.gameBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.gameBuildStage == -1) {
                attributes.add("game");
            }
            return "Cannot build GetBotCallbackAnswer, attribute initializers form cycle " + attributes;
        }
    }
}

