/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.messages;

import java.util.ArrayList;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.InputPeer;
import telegram4j.tl.InputUser;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.messages.GetChatInviteImporters;

public final class ImmutableGetChatInviteImporters
implements GetChatInviteImporters {
    private final int identifier;
    private final int flags;
    private final boolean requested;
    private final InputPeer peer;
    @Nullable
    private final String link;
    @Nullable
    private final String q;
    private final int offsetDate;
    private final InputUser offsetUser;
    private final int limit;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableGetChatInviteImporters(InputPeer peer, int offsetDate, InputUser offsetUser, int limit) {
        this.peer = Objects.requireNonNull(peer, "peer");
        this.offsetDate = offsetDate;
        this.offsetUser = Objects.requireNonNull(offsetUser, "offsetUser");
        this.limit = limit;
        this.link = null;
        this.q = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.requested = this.initShim.requested();
        this.initShim = null;
    }

    private ImmutableGetChatInviteImporters(Builder builder) {
        this.peer = builder.peer;
        this.link = builder.link;
        this.q = builder.q;
        this.offsetDate = builder.offsetDate;
        this.offsetUser = builder.offsetUser;
        this.limit = builder.limit;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.requestedIsSet()) {
            this.initShim.requested(builder.requested);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.requested = this.initShim.requested();
        this.initShim = null;
    }

    private ImmutableGetChatInviteImporters(int identifier, int flags, boolean requested, InputPeer peer, @Nullable String link, @Nullable String q, int offsetDate, InputUser offsetUser, int limit) {
        this.identifier = identifier;
        this.flags = flags;
        this.requested = requested;
        this.peer = peer;
        this.link = link;
        this.q = q;
        this.offsetDate = offsetDate;
        this.offsetUser = offsetUser;
        this.limit = limit;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return GetChatInviteImporters.super.identifier();
    }

    private int flagsInitialize() {
        return GetChatInviteImporters.super.flags();
    }

    private boolean requestedInitialize() {
        return GetChatInviteImporters.super.requested();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean requested() {
        InitShim shim = this.initShim;
        return shim != null ? shim.requested() : this.requested;
    }

    @Override
    public InputPeer peer() {
        return this.peer;
    }

    @Override
    @Nullable
    public String link() {
        return this.link;
    }

    @Override
    @Nullable
    public String q() {
        return this.q;
    }

    @Override
    public int offsetDate() {
        return this.offsetDate;
    }

    @Override
    public InputUser offsetUser() {
        return this.offsetUser;
    }

    @Override
    public int limit() {
        return this.limit;
    }

    public final ImmutableGetChatInviteImporters withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableGetChatInviteImporters(value, this.flags, this.requested, this.peer, this.link, this.q, this.offsetDate, this.offsetUser, this.limit);
    }

    public final ImmutableGetChatInviteImporters withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableGetChatInviteImporters(this.identifier, value, this.requested, this.peer, this.link, this.q, this.offsetDate, this.offsetUser, this.limit);
    }

    public final ImmutableGetChatInviteImporters withRequested(boolean value) {
        if (this.requested == value) {
            return this;
        }
        return new ImmutableGetChatInviteImporters(this.identifier, this.flags, value, this.peer, this.link, this.q, this.offsetDate, this.offsetUser, this.limit);
    }

    public final ImmutableGetChatInviteImporters withPeer(InputPeer value) {
        if (this.peer == value) {
            return this;
        }
        InputPeer newValue = Objects.requireNonNull(value, "peer");
        return new ImmutableGetChatInviteImporters(this.identifier, this.flags, this.requested, newValue, this.link, this.q, this.offsetDate, this.offsetUser, this.limit);
    }

    public final ImmutableGetChatInviteImporters withLink(@Nullable String value) {
        if (Objects.equals(this.link, value)) {
            return this;
        }
        return new ImmutableGetChatInviteImporters(this.identifier, this.flags, this.requested, this.peer, value, this.q, this.offsetDate, this.offsetUser, this.limit);
    }

    public final ImmutableGetChatInviteImporters withQ(@Nullable String value) {
        if (Objects.equals(this.q, value)) {
            return this;
        }
        return new ImmutableGetChatInviteImporters(this.identifier, this.flags, this.requested, this.peer, this.link, value, this.offsetDate, this.offsetUser, this.limit);
    }

    public final ImmutableGetChatInviteImporters withOffsetDate(int value) {
        if (this.offsetDate == value) {
            return this;
        }
        return new ImmutableGetChatInviteImporters(this.identifier, this.flags, this.requested, this.peer, this.link, this.q, value, this.offsetUser, this.limit);
    }

    public final ImmutableGetChatInviteImporters withOffsetUser(InputUser value) {
        if (this.offsetUser == value) {
            return this;
        }
        InputUser newValue = Objects.requireNonNull(value, "offsetUser");
        return new ImmutableGetChatInviteImporters(this.identifier, this.flags, this.requested, this.peer, this.link, this.q, this.offsetDate, newValue, this.limit);
    }

    public final ImmutableGetChatInviteImporters withLimit(int value) {
        if (this.limit == value) {
            return this;
        }
        return new ImmutableGetChatInviteImporters(this.identifier, this.flags, this.requested, this.peer, this.link, this.q, this.offsetDate, this.offsetUser, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGetChatInviteImporters && this.equalTo(0, (ImmutableGetChatInviteImporters)another);
    }

    private boolean equalTo(int synthetic, ImmutableGetChatInviteImporters another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.requested == another.requested && this.peer.equals(another.peer) && Objects.equals(this.link, another.link) && Objects.equals(this.q, another.q) && this.offsetDate == another.offsetDate && this.offsetUser.equals(another.offsetUser) && this.limit == another.limit;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.requested);
        h += (h << 5) + this.peer.hashCode();
        h += (h << 5) + Objects.hashCode(this.link);
        h += (h << 5) + Objects.hashCode(this.q);
        h += (h << 5) + this.offsetDate;
        h += (h << 5) + this.offsetUser.hashCode();
        h += (h << 5) + this.limit;
        return h;
    }

    public String toString() {
        return "GetChatInviteImporters{identifier=" + this.identifier + ", flags=" + this.flags + ", requested=" + this.requested + ", peer=" + this.peer + ", link=" + this.link + ", q=" + this.q + ", offsetDate=" + this.offsetDate + ", offsetUser=" + this.offsetUser + ", limit=" + this.limit + "}";
    }

    public static ImmutableGetChatInviteImporters of(InputPeer peer, int offsetDate, InputUser offsetUser, int limit) {
        return new ImmutableGetChatInviteImporters(peer, offsetDate, offsetUser, limit);
    }

    public static ImmutableGetChatInviteImporters copyOf(GetChatInviteImporters instance) {
        if (instance instanceof ImmutableGetChatInviteImporters) {
            return (ImmutableGetChatInviteImporters)instance;
        }
        return ImmutableGetChatInviteImporters.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PEER = 1L;
        private static final long INIT_BIT_OFFSET_DATE = 2L;
        private static final long INIT_BIT_OFFSET_USER = 4L;
        private static final long INIT_BIT_LIMIT = 8L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_REQUESTED = 4L;
        private long initBits = 15L;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean requested;
        private InputPeer peer;
        private String link;
        private String q;
        private int offsetDate;
        private InputUser offsetUser;
        private int limit;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(GetChatInviteImporters instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof GetChatInviteImporters) {
                String qValue;
                instance = (GetChatInviteImporters)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((qValue = instance.q()) != null) {
                    this.q(qValue);
                }
                this.requested(instance.requested());
                this.peer(instance.peer());
                this.flags(instance.flags());
                String linkValue = instance.link();
                if (linkValue != null) {
                    this.link(linkValue);
                }
                this.limit(instance.limit());
                this.offsetUser(instance.offsetUser());
                this.offsetDate(instance.offsetDate());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder requested(boolean requested) {
            this.requested = requested;
            this.optBits |= 4L;
            return this;
        }

        public final Builder peer(InputPeer peer) {
            this.peer = Objects.requireNonNull(peer, "peer");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder link(@Nullable String link) {
            this.link = link;
            return this;
        }

        public final Builder q(@Nullable String q) {
            this.q = q;
            return this;
        }

        public final Builder offsetDate(int offsetDate) {
            this.offsetDate = offsetDate;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder offsetUser(InputUser offsetUser) {
            this.offsetUser = Objects.requireNonNull(offsetUser, "offsetUser");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder limit(int limit) {
            this.limit = limit;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public ImmutableGetChatInviteImporters build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableGetChatInviteImporters(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean requestedIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("peer");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("offsetDate");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("offsetUser");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("limit");
            }
            return "Cannot build GetChatInviteImporters, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte requestedBuildStage = 0;
        private boolean requested;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableGetChatInviteImporters.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableGetChatInviteImporters.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean requested() {
            if (this.requestedBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.requestedBuildStage == 0) {
                this.requestedBuildStage = (byte)-1;
                this.requested = ImmutableGetChatInviteImporters.this.requestedInitialize();
                this.requestedBuildStage = 1;
            }
            return this.requested;
        }

        void requested(boolean requested) {
            this.requested = requested;
            this.requestedBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.requestedBuildStage == -1) {
                attributes.add("requested");
            }
            return "Cannot build GetChatInviteImporters, attribute initializers form cycle " + attributes;
        }
    }
}

