/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.messages;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.messages.GetChats;

public final class ImmutableGetChats
implements GetChats {
    private final int identifier;
    private final List<Long> id;

    private ImmutableGetChats(Builder builder) {
        this.id = ImmutableGetChats.createUnmodifiableList(true, builder.id);
        this.identifier = builder.identifierIsSet() ? builder.identifier : GetChats.super.identifier();
    }

    private ImmutableGetChats(int identifier, List<Long> id) {
        this.identifier = identifier;
        this.id = id;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public List<Long> id() {
        return this.id;
    }

    public final ImmutableGetChats withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableGetChats(value, this.id);
    }

    public final ImmutableGetChats withId(long ... elements) {
        ArrayList<Long> wrappedList = new ArrayList<Long>(elements.length);
        for (long element : elements) {
            wrappedList.add(element);
        }
        List<Long> newValue = ImmutableGetChats.createUnmodifiableList(false, wrappedList);
        return new ImmutableGetChats(this.identifier, newValue);
    }

    public final ImmutableGetChats withId(Iterable<Long> elements) {
        if (this.id == elements) {
            return this;
        }
        List<Long> newValue = ImmutableGetChats.createUnmodifiableList(false, ImmutableGetChats.createSafeList(elements, true, false));
        return new ImmutableGetChats(this.identifier, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGetChats && this.equalTo(0, (ImmutableGetChats)another);
    }

    private boolean equalTo(int synthetic, ImmutableGetChats another) {
        return this.identifier == another.identifier && this.id.equals(another.id);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.id.hashCode();
        return h;
    }

    public String toString() {
        return "GetChats{identifier=" + this.identifier + ", id=" + this.id + "}";
    }

    public static ImmutableGetChats copyOf(GetChats instance) {
        if (instance instanceof ImmutableGetChats) {
            return (ImmutableGetChats)instance;
        }
        return ImmutableGetChats.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long optBits;
        private int identifier;
        private List<Long> id = new ArrayList<Long>();

        private Builder() {
        }

        public final Builder from(GetChats instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            GetChats instance;
            long bits = 0L;
            if (object instanceof GetChats) {
                instance = (GetChats)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.addAllId(instance.id());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder addId(long element) {
            this.id.add(element);
            return this;
        }

        public final Builder addId(long ... elements) {
            for (long element : elements) {
                this.id.add(element);
            }
            return this;
        }

        public final Builder id(Iterable<Long> elements) {
            this.id.clear();
            return this.addAllId(elements);
        }

        public final Builder addAllId(Iterable<Long> elements) {
            for (Long element : elements) {
                this.id.add(Objects.requireNonNull(element, "id element"));
            }
            return this;
        }

        public ImmutableGetChats build() {
            return new ImmutableGetChats(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }
}

