/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.messages;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputUser;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.messages.GetCommonChats;

public final class ImmutableGetCommonChats
implements GetCommonChats {
    private final int identifier;
    private final InputUser userId;
    private final long maxId;
    private final int limit;

    private ImmutableGetCommonChats(InputUser userId, long maxId, int limit) {
        this.userId = Objects.requireNonNull(userId, "userId");
        this.maxId = maxId;
        this.limit = limit;
        this.identifier = GetCommonChats.super.identifier();
    }

    private ImmutableGetCommonChats(Builder builder) {
        this.userId = builder.userId;
        this.maxId = builder.maxId;
        this.limit = builder.limit;
        this.identifier = builder.identifierIsSet() ? builder.identifier : GetCommonChats.super.identifier();
    }

    private ImmutableGetCommonChats(int identifier, InputUser userId, long maxId, int limit) {
        this.identifier = identifier;
        this.userId = userId;
        this.maxId = maxId;
        this.limit = limit;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public InputUser userId() {
        return this.userId;
    }

    @Override
    public long maxId() {
        return this.maxId;
    }

    @Override
    public int limit() {
        return this.limit;
    }

    public final ImmutableGetCommonChats withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableGetCommonChats(value, this.userId, this.maxId, this.limit);
    }

    public final ImmutableGetCommonChats withUserId(InputUser value) {
        if (this.userId == value) {
            return this;
        }
        InputUser newValue = Objects.requireNonNull(value, "userId");
        return new ImmutableGetCommonChats(this.identifier, newValue, this.maxId, this.limit);
    }

    public final ImmutableGetCommonChats withMaxId(long value) {
        if (this.maxId == value) {
            return this;
        }
        return new ImmutableGetCommonChats(this.identifier, this.userId, value, this.limit);
    }

    public final ImmutableGetCommonChats withLimit(int value) {
        if (this.limit == value) {
            return this;
        }
        return new ImmutableGetCommonChats(this.identifier, this.userId, this.maxId, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGetCommonChats && this.equalTo(0, (ImmutableGetCommonChats)another);
    }

    private boolean equalTo(int synthetic, ImmutableGetCommonChats another) {
        return this.identifier == another.identifier && this.userId.equals(another.userId) && this.maxId == another.maxId && this.limit == another.limit;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.userId.hashCode();
        h += (h << 5) + Long.hashCode(this.maxId);
        h += (h << 5) + this.limit;
        return h;
    }

    public String toString() {
        return "GetCommonChats{identifier=" + this.identifier + ", userId=" + this.userId + ", maxId=" + this.maxId + ", limit=" + this.limit + "}";
    }

    public static ImmutableGetCommonChats of(InputUser userId, long maxId, int limit) {
        return new ImmutableGetCommonChats(userId, maxId, limit);
    }

    public static ImmutableGetCommonChats copyOf(GetCommonChats instance) {
        if (instance instanceof ImmutableGetCommonChats) {
            return (ImmutableGetCommonChats)instance;
        }
        return ImmutableGetCommonChats.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_USER_ID = 1L;
        private static final long INIT_BIT_MAX_ID = 2L;
        private static final long INIT_BIT_LIMIT = 4L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 7L;
        private long optBits;
        private int identifier;
        private InputUser userId;
        private long maxId;
        private int limit;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(GetCommonChats instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof GetCommonChats) {
                instance = (GetCommonChats)object;
                this.limit(instance.limit());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.maxId(instance.maxId());
                this.userId(instance.userId());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder userId(InputUser userId) {
            this.userId = Objects.requireNonNull(userId, "userId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder maxId(long maxId) {
            this.maxId = maxId;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder limit(int limit) {
            this.limit = limit;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableGetCommonChats build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableGetCommonChats(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("userId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("maxId");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("limit");
            }
            return "Cannot build GetCommonChats, some of required attributes are not set " + attributes;
        }
    }
}

