/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.messages;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.messages.GetCustomEmojiDocuments;

public final class ImmutableGetCustomEmojiDocuments
implements GetCustomEmojiDocuments {
    private final int identifier;
    private final List<Long> documentId;

    private ImmutableGetCustomEmojiDocuments(Builder builder) {
        this.documentId = ImmutableGetCustomEmojiDocuments.createUnmodifiableList(true, builder.documentId);
        this.identifier = builder.identifierIsSet() ? builder.identifier : GetCustomEmojiDocuments.super.identifier();
    }

    private ImmutableGetCustomEmojiDocuments(int identifier, List<Long> documentId) {
        this.identifier = identifier;
        this.documentId = documentId;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public List<Long> documentId() {
        return this.documentId;
    }

    public final ImmutableGetCustomEmojiDocuments withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableGetCustomEmojiDocuments(value, this.documentId);
    }

    public final ImmutableGetCustomEmojiDocuments withDocumentId(long ... elements) {
        ArrayList<Long> wrappedList = new ArrayList<Long>(elements.length);
        for (long element : elements) {
            wrappedList.add(element);
        }
        List<Long> newValue = ImmutableGetCustomEmojiDocuments.createUnmodifiableList(false, wrappedList);
        return new ImmutableGetCustomEmojiDocuments(this.identifier, newValue);
    }

    public final ImmutableGetCustomEmojiDocuments withDocumentId(Iterable<Long> elements) {
        if (this.documentId == elements) {
            return this;
        }
        List<Long> newValue = ImmutableGetCustomEmojiDocuments.createUnmodifiableList(false, ImmutableGetCustomEmojiDocuments.createSafeList(elements, true, false));
        return new ImmutableGetCustomEmojiDocuments(this.identifier, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGetCustomEmojiDocuments && this.equalTo(0, (ImmutableGetCustomEmojiDocuments)another);
    }

    private boolean equalTo(int synthetic, ImmutableGetCustomEmojiDocuments another) {
        return this.identifier == another.identifier && this.documentId.equals(another.documentId);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.documentId.hashCode();
        return h;
    }

    public String toString() {
        return "GetCustomEmojiDocuments{identifier=" + this.identifier + ", documentId=" + this.documentId + "}";
    }

    public static ImmutableGetCustomEmojiDocuments copyOf(GetCustomEmojiDocuments instance) {
        if (instance instanceof ImmutableGetCustomEmojiDocuments) {
            return (ImmutableGetCustomEmojiDocuments)instance;
        }
        return ImmutableGetCustomEmojiDocuments.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long optBits;
        private int identifier;
        private List<Long> documentId = new ArrayList<Long>();

        private Builder() {
        }

        public final Builder from(GetCustomEmojiDocuments instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            GetCustomEmojiDocuments instance;
            long bits = 0L;
            if (object instanceof GetCustomEmojiDocuments) {
                instance = (GetCustomEmojiDocuments)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.addAllDocumentId(instance.documentId());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder addDocumentId(long element) {
            this.documentId.add(element);
            return this;
        }

        public final Builder addDocumentId(long ... elements) {
            for (long element : elements) {
                this.documentId.add(element);
            }
            return this;
        }

        public final Builder documentId(Iterable<Long> elements) {
            this.documentId.clear();
            return this.addAllDocumentId(elements);
        }

        public final Builder addAllDocumentId(Iterable<Long> elements) {
            for (Long element : elements) {
                this.documentId.add(Objects.requireNonNull(element, "documentId element"));
            }
            return this;
        }

        public ImmutableGetCustomEmojiDocuments build() {
            return new ImmutableGetCustomEmojiDocuments(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }
}

