/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.messages;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.messages.GetDhConfig;

public final class ImmutableGetDhConfig
implements GetDhConfig {
    private final int identifier;
    private final int version;
    private final int randomLength;

    private ImmutableGetDhConfig(int version, int randomLength) {
        this.version = version;
        this.randomLength = randomLength;
        this.identifier = GetDhConfig.super.identifier();
    }

    private ImmutableGetDhConfig(Builder builder) {
        this.version = builder.version;
        this.randomLength = builder.randomLength;
        this.identifier = builder.identifierIsSet() ? builder.identifier : GetDhConfig.super.identifier();
    }

    private ImmutableGetDhConfig(int identifier, int version, int randomLength) {
        this.identifier = identifier;
        this.version = version;
        this.randomLength = randomLength;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public int version() {
        return this.version;
    }

    @Override
    public int randomLength() {
        return this.randomLength;
    }

    public final ImmutableGetDhConfig withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableGetDhConfig(value, this.version, this.randomLength);
    }

    public final ImmutableGetDhConfig withVersion(int value) {
        if (this.version == value) {
            return this;
        }
        return new ImmutableGetDhConfig(this.identifier, value, this.randomLength);
    }

    public final ImmutableGetDhConfig withRandomLength(int value) {
        if (this.randomLength == value) {
            return this;
        }
        return new ImmutableGetDhConfig(this.identifier, this.version, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGetDhConfig && this.equalTo(0, (ImmutableGetDhConfig)another);
    }

    private boolean equalTo(int synthetic, ImmutableGetDhConfig another) {
        return this.identifier == another.identifier && this.version == another.version && this.randomLength == another.randomLength;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.version;
        h += (h << 5) + this.randomLength;
        return h;
    }

    public String toString() {
        return "GetDhConfig{identifier=" + this.identifier + ", version=" + this.version + ", randomLength=" + this.randomLength + "}";
    }

    public static ImmutableGetDhConfig of(int version, int randomLength) {
        return new ImmutableGetDhConfig(version, randomLength);
    }

    public static ImmutableGetDhConfig copyOf(GetDhConfig instance) {
        if (instance instanceof ImmutableGetDhConfig) {
            return (ImmutableGetDhConfig)instance;
        }
        return ImmutableGetDhConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_VERSION = 1L;
        private static final long INIT_BIT_RANDOM_LENGTH = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private int version;
        private int randomLength;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(GetDhConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof GetDhConfig) {
                instance = (GetDhConfig)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.version(instance.version());
                this.randomLength(instance.randomLength());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder version(int version) {
            this.version = version;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder randomLength(int randomLength) {
            this.randomLength = randomLength;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableGetDhConfig build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableGetDhConfig(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("version");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("randomLength");
            }
            return "Cannot build GetDhConfig, some of required attributes are not set " + attributes;
        }
    }
}

