/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.messages;

import java.util.ArrayList;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.InputPeer;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.messages.GetDialogs;

public final class ImmutableGetDialogs
implements GetDialogs {
    private final int identifier;
    private final int flags;
    private final boolean excludePinned;
    @Nullable
    private final Integer folderId;
    private final int offsetDate;
    private final int offsetId;
    private final InputPeer offsetPeer;
    private final int limit;
    private final long hash;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableGetDialogs(int offsetDate, int offsetId, InputPeer offsetPeer, int limit, long hash) {
        this.offsetDate = offsetDate;
        this.offsetId = offsetId;
        this.offsetPeer = Objects.requireNonNull(offsetPeer, "offsetPeer");
        this.limit = limit;
        this.hash = hash;
        this.folderId = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.excludePinned = this.initShim.excludePinned();
        this.initShim = null;
    }

    private ImmutableGetDialogs(Builder builder) {
        this.folderId = builder.folderId;
        this.offsetDate = builder.offsetDate;
        this.offsetId = builder.offsetId;
        this.offsetPeer = builder.offsetPeer;
        this.limit = builder.limit;
        this.hash = builder.hash;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.excludePinnedIsSet()) {
            this.initShim.excludePinned(builder.excludePinned);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.excludePinned = this.initShim.excludePinned();
        this.initShim = null;
    }

    private ImmutableGetDialogs(int identifier, int flags, boolean excludePinned, @Nullable Integer folderId, int offsetDate, int offsetId, InputPeer offsetPeer, int limit, long hash) {
        this.identifier = identifier;
        this.flags = flags;
        this.excludePinned = excludePinned;
        this.folderId = folderId;
        this.offsetDate = offsetDate;
        this.offsetId = offsetId;
        this.offsetPeer = offsetPeer;
        this.limit = limit;
        this.hash = hash;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return GetDialogs.super.identifier();
    }

    private int flagsInitialize() {
        return GetDialogs.super.flags();
    }

    private boolean excludePinnedInitialize() {
        return GetDialogs.super.excludePinned();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean excludePinned() {
        InitShim shim = this.initShim;
        return shim != null ? shim.excludePinned() : this.excludePinned;
    }

    @Override
    @Nullable
    public Integer folderId() {
        return this.folderId;
    }

    @Override
    public int offsetDate() {
        return this.offsetDate;
    }

    @Override
    public int offsetId() {
        return this.offsetId;
    }

    @Override
    public InputPeer offsetPeer() {
        return this.offsetPeer;
    }

    @Override
    public int limit() {
        return this.limit;
    }

    @Override
    public long hash() {
        return this.hash;
    }

    public final ImmutableGetDialogs withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableGetDialogs(value, this.flags, this.excludePinned, this.folderId, this.offsetDate, this.offsetId, this.offsetPeer, this.limit, this.hash);
    }

    public final ImmutableGetDialogs withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableGetDialogs(this.identifier, value, this.excludePinned, this.folderId, this.offsetDate, this.offsetId, this.offsetPeer, this.limit, this.hash);
    }

    public final ImmutableGetDialogs withExcludePinned(boolean value) {
        if (this.excludePinned == value) {
            return this;
        }
        return new ImmutableGetDialogs(this.identifier, this.flags, value, this.folderId, this.offsetDate, this.offsetId, this.offsetPeer, this.limit, this.hash);
    }

    public final ImmutableGetDialogs withFolderId(@Nullable Integer value) {
        if (Objects.equals(this.folderId, value)) {
            return this;
        }
        return new ImmutableGetDialogs(this.identifier, this.flags, this.excludePinned, value, this.offsetDate, this.offsetId, this.offsetPeer, this.limit, this.hash);
    }

    public final ImmutableGetDialogs withOffsetDate(int value) {
        if (this.offsetDate == value) {
            return this;
        }
        return new ImmutableGetDialogs(this.identifier, this.flags, this.excludePinned, this.folderId, value, this.offsetId, this.offsetPeer, this.limit, this.hash);
    }

    public final ImmutableGetDialogs withOffsetId(int value) {
        if (this.offsetId == value) {
            return this;
        }
        return new ImmutableGetDialogs(this.identifier, this.flags, this.excludePinned, this.folderId, this.offsetDate, value, this.offsetPeer, this.limit, this.hash);
    }

    public final ImmutableGetDialogs withOffsetPeer(InputPeer value) {
        if (this.offsetPeer == value) {
            return this;
        }
        InputPeer newValue = Objects.requireNonNull(value, "offsetPeer");
        return new ImmutableGetDialogs(this.identifier, this.flags, this.excludePinned, this.folderId, this.offsetDate, this.offsetId, newValue, this.limit, this.hash);
    }

    public final ImmutableGetDialogs withLimit(int value) {
        if (this.limit == value) {
            return this;
        }
        return new ImmutableGetDialogs(this.identifier, this.flags, this.excludePinned, this.folderId, this.offsetDate, this.offsetId, this.offsetPeer, value, this.hash);
    }

    public final ImmutableGetDialogs withHash(long value) {
        if (this.hash == value) {
            return this;
        }
        return new ImmutableGetDialogs(this.identifier, this.flags, this.excludePinned, this.folderId, this.offsetDate, this.offsetId, this.offsetPeer, this.limit, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGetDialogs && this.equalTo(0, (ImmutableGetDialogs)another);
    }

    private boolean equalTo(int synthetic, ImmutableGetDialogs another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.excludePinned == another.excludePinned && Objects.equals(this.folderId, another.folderId) && this.offsetDate == another.offsetDate && this.offsetId == another.offsetId && this.offsetPeer.equals(another.offsetPeer) && this.limit == another.limit && this.hash == another.hash;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.excludePinned);
        h += (h << 5) + Objects.hashCode(this.folderId);
        h += (h << 5) + this.offsetDate;
        h += (h << 5) + this.offsetId;
        h += (h << 5) + this.offsetPeer.hashCode();
        h += (h << 5) + this.limit;
        h += (h << 5) + Long.hashCode(this.hash);
        return h;
    }

    public String toString() {
        return "GetDialogs{identifier=" + this.identifier + ", flags=" + this.flags + ", excludePinned=" + this.excludePinned + ", folderId=" + this.folderId + ", offsetDate=" + this.offsetDate + ", offsetId=" + this.offsetId + ", offsetPeer=" + this.offsetPeer + ", limit=" + this.limit + ", hash=" + this.hash + "}";
    }

    public static ImmutableGetDialogs of(int offsetDate, int offsetId, InputPeer offsetPeer, int limit, long hash) {
        return new ImmutableGetDialogs(offsetDate, offsetId, offsetPeer, limit, hash);
    }

    public static ImmutableGetDialogs copyOf(GetDialogs instance) {
        if (instance instanceof ImmutableGetDialogs) {
            return (ImmutableGetDialogs)instance;
        }
        return ImmutableGetDialogs.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_OFFSET_DATE = 1L;
        private static final long INIT_BIT_OFFSET_ID = 2L;
        private static final long INIT_BIT_OFFSET_PEER = 4L;
        private static final long INIT_BIT_LIMIT = 8L;
        private static final long INIT_BIT_HASH = 16L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_EXCLUDE_PINNED = 4L;
        private long initBits = 31L;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean excludePinned;
        private Integer folderId;
        private int offsetDate;
        private int offsetId;
        private InputPeer offsetPeer;
        private int limit;
        private long hash;

        private Builder() {
        }

        public final Builder from(GetDialogs instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            GetDialogs instance;
            long bits = 0L;
            if (object instanceof GetDialogs) {
                instance = (GetDialogs)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.excludePinned(instance.excludePinned());
                this.offsetPeer(instance.offsetPeer());
                this.flags(instance.flags());
                this.limit(instance.limit());
                this.offsetDate(instance.offsetDate());
                Integer folderIdValue = instance.folderId();
                if (folderIdValue != null) {
                    this.folderId(folderIdValue);
                }
                this.offsetId(instance.offsetId());
                this.hash(instance.hash());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder excludePinned(boolean excludePinned) {
            this.excludePinned = excludePinned;
            this.optBits |= 4L;
            return this;
        }

        public final Builder folderId(@Nullable Integer folderId) {
            this.folderId = folderId;
            return this;
        }

        public final Builder offsetDate(int offsetDate) {
            this.offsetDate = offsetDate;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder offsetId(int offsetId) {
            this.offsetId = offsetId;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder offsetPeer(InputPeer offsetPeer) {
            this.offsetPeer = Objects.requireNonNull(offsetPeer, "offsetPeer");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder limit(int limit) {
            this.limit = limit;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder hash(long hash) {
            this.hash = hash;
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public ImmutableGetDialogs build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableGetDialogs(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean excludePinnedIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("offsetDate");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("offsetId");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("offsetPeer");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("limit");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("hash");
            }
            return "Cannot build GetDialogs, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte excludePinnedBuildStage = 0;
        private boolean excludePinned;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableGetDialogs.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableGetDialogs.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean excludePinned() {
            if (this.excludePinnedBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.excludePinnedBuildStage == 0) {
                this.excludePinnedBuildStage = (byte)-1;
                this.excludePinned = ImmutableGetDialogs.this.excludePinnedInitialize();
                this.excludePinnedBuildStage = 1;
            }
            return this.excludePinned;
        }

        void excludePinned(boolean excludePinned) {
            this.excludePinned = excludePinned;
            this.excludePinnedBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.excludePinnedBuildStage == -1) {
                attributes.add("excludePinned");
            }
            return "Cannot build GetDialogs, attribute initializers form cycle " + attributes;
        }
    }
}

