/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.messages;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.api.TlEncodingUtil;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.messages.GetDocumentByHash;

public final class ImmutableGetDocumentByHash
implements GetDocumentByHash {
    private final int identifier;
    private final ByteBuf sha256;
    private final long size;
    private final String mimeType;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableGetDocumentByHash(long size, String mimeType) {
        this.size = size;
        this.mimeType = Objects.requireNonNull(mimeType, "mimeType");
        this.sha256 = null;
        this.identifier = this.initShim.identifier();
        this.initShim = null;
    }

    private ImmutableGetDocumentByHash(Builder builder) {
        this.sha256 = builder.sha256_build();
        this.size = builder.size;
        this.mimeType = builder.mimeType;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        this.identifier = this.initShim.identifier();
        this.initShim = null;
    }

    private ImmutableGetDocumentByHash(int identifier, ByteBuf sha256, long size, String mimeType) {
        this.identifier = identifier;
        this.sha256 = sha256;
        this.size = size;
        this.mimeType = mimeType;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return GetDocumentByHash.super.identifier();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public ByteBuf sha256() {
        return this.sha256.duplicate();
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    public String mimeType() {
        return this.mimeType;
    }

    public final ImmutableGetDocumentByHash withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableGetDocumentByHash(value, this.sha256, this.size, this.mimeType);
    }

    public ImmutableGetDocumentByHash withSha256(ByteBuf value) {
        ByteBuf newValue = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
        if (this.sha256 == newValue) {
            return this;
        }
        return new ImmutableGetDocumentByHash(this.identifier, newValue, this.size, this.mimeType);
    }

    public final ImmutableGetDocumentByHash withSize(long value) {
        if (this.size == value) {
            return this;
        }
        return new ImmutableGetDocumentByHash(this.identifier, this.sha256, value, this.mimeType);
    }

    public final ImmutableGetDocumentByHash withMimeType(String value) {
        String newValue = Objects.requireNonNull(value, "mimeType");
        if (this.mimeType.equals(newValue)) {
            return this;
        }
        return new ImmutableGetDocumentByHash(this.identifier, this.sha256, this.size, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGetDocumentByHash && this.equalTo(0, (ImmutableGetDocumentByHash)another);
    }

    private boolean equalTo(int synthetic, ImmutableGetDocumentByHash another) {
        return this.identifier == another.identifier && this.sha256().equals((Object)another.sha256()) && this.size == another.size && this.mimeType.equals(another.mimeType);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.sha256().hashCode();
        h += (h << 5) + Long.hashCode(this.size);
        h += (h << 5) + this.mimeType.hashCode();
        return h;
    }

    public String toString() {
        return "GetDocumentByHash{identifier=" + this.identifier + ", sha256=" + ByteBufUtil.hexDump((ByteBuf)this.sha256) + ", size=" + this.size + ", mimeType=" + this.mimeType + "}";
    }

    public static ImmutableGetDocumentByHash of(long size, String mimeType) {
        return new ImmutableGetDocumentByHash(size, mimeType);
    }

    public static ImmutableGetDocumentByHash copyOf(GetDocumentByHash instance) {
        if (instance instanceof ImmutableGetDocumentByHash) {
            return (ImmutableGetDocumentByHash)instance;
        }
        return ImmutableGetDocumentByHash.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_SIZE = 1L;
        private static final long INIT_BIT_MIME_TYPE = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private ByteBuf sha256_value = null;
        private int identifier;
        private long size;
        private String mimeType;

        private Builder() {
        }

        public final Builder from(GetDocumentByHash instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            GetDocumentByHash instance;
            long bits = 0L;
            if (object instanceof GetDocumentByHash) {
                instance = (GetDocumentByHash)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.mimeType(instance.mimeType());
                this.sha256(instance.sha256());
                this.size(instance.size());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public Builder sha256(ByteBuf value) {
            this.sha256_value = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
            return this;
        }

        public final Builder size(long size) {
            this.size = size;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder mimeType(String mimeType) {
            this.mimeType = Objects.requireNonNull(mimeType, "mimeType");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableGetDocumentByHash build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableGetDocumentByHash(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("size");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("mimeType");
            }
            return "Cannot build GetDocumentByHash, some of required attributes are not set " + attributes;
        }

        private ByteBuf sha256_build() {
            return Objects.requireNonNull(this.sha256_value);
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableGetDocumentByHash.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            return "Cannot build GetDocumentByHash, attribute initializers form cycle " + attributes;
        }
    }
}

