/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.messages;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.messages.GetEmojiKeywords;

public final class ImmutableGetEmojiKeywords
implements GetEmojiKeywords {
    private final int identifier;
    private final String langCode;

    private ImmutableGetEmojiKeywords(String langCode) {
        this.langCode = Objects.requireNonNull(langCode, "langCode");
        this.identifier = GetEmojiKeywords.super.identifier();
    }

    private ImmutableGetEmojiKeywords(Builder builder) {
        this.langCode = builder.langCode;
        this.identifier = builder.identifierIsSet() ? builder.identifier : GetEmojiKeywords.super.identifier();
    }

    private ImmutableGetEmojiKeywords(int identifier, String langCode) {
        this.identifier = identifier;
        this.langCode = langCode;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public String langCode() {
        return this.langCode;
    }

    public final ImmutableGetEmojiKeywords withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableGetEmojiKeywords(value, this.langCode);
    }

    public final ImmutableGetEmojiKeywords withLangCode(String value) {
        String newValue = Objects.requireNonNull(value, "langCode");
        if (this.langCode.equals(newValue)) {
            return this;
        }
        return new ImmutableGetEmojiKeywords(this.identifier, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGetEmojiKeywords && this.equalTo(0, (ImmutableGetEmojiKeywords)another);
    }

    private boolean equalTo(int synthetic, ImmutableGetEmojiKeywords another) {
        return this.identifier == another.identifier && this.langCode.equals(another.langCode);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.langCode.hashCode();
        return h;
    }

    public String toString() {
        return "GetEmojiKeywords{identifier=" + this.identifier + ", langCode=" + this.langCode + "}";
    }

    public static ImmutableGetEmojiKeywords of(String langCode) {
        return new ImmutableGetEmojiKeywords(langCode);
    }

    public static ImmutableGetEmojiKeywords copyOf(GetEmojiKeywords instance) {
        if (instance instanceof ImmutableGetEmojiKeywords) {
            return (ImmutableGetEmojiKeywords)instance;
        }
        return ImmutableGetEmojiKeywords.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_LANG_CODE = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private String langCode;

        private Builder() {
        }

        public final Builder from(GetEmojiKeywords instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            GetEmojiKeywords instance;
            long bits = 0L;
            if (object instanceof GetEmojiKeywords) {
                instance = (GetEmojiKeywords)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.langCode(instance.langCode());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder langCode(String langCode) {
            this.langCode = Objects.requireNonNull(langCode, "langCode");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableGetEmojiKeywords build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableGetEmojiKeywords(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("langCode");
            }
            return "Cannot build GetEmojiKeywords, some of required attributes are not set " + attributes;
        }
    }
}

