/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.messages;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.messages.GetEmojiKeywordsDifference;

public final class ImmutableGetEmojiKeywordsDifference
implements GetEmojiKeywordsDifference {
    private final int identifier;
    private final String langCode;
    private final int fromVersion;

    private ImmutableGetEmojiKeywordsDifference(String langCode, int fromVersion) {
        this.langCode = Objects.requireNonNull(langCode, "langCode");
        this.fromVersion = fromVersion;
        this.identifier = GetEmojiKeywordsDifference.super.identifier();
    }

    private ImmutableGetEmojiKeywordsDifference(Builder builder) {
        this.langCode = builder.langCode;
        this.fromVersion = builder.fromVersion;
        this.identifier = builder.identifierIsSet() ? builder.identifier : GetEmojiKeywordsDifference.super.identifier();
    }

    private ImmutableGetEmojiKeywordsDifference(int identifier, String langCode, int fromVersion) {
        this.identifier = identifier;
        this.langCode = langCode;
        this.fromVersion = fromVersion;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public String langCode() {
        return this.langCode;
    }

    @Override
    public int fromVersion() {
        return this.fromVersion;
    }

    public final ImmutableGetEmojiKeywordsDifference withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableGetEmojiKeywordsDifference(value, this.langCode, this.fromVersion);
    }

    public final ImmutableGetEmojiKeywordsDifference withLangCode(String value) {
        String newValue = Objects.requireNonNull(value, "langCode");
        if (this.langCode.equals(newValue)) {
            return this;
        }
        return new ImmutableGetEmojiKeywordsDifference(this.identifier, newValue, this.fromVersion);
    }

    public final ImmutableGetEmojiKeywordsDifference withFromVersion(int value) {
        if (this.fromVersion == value) {
            return this;
        }
        return new ImmutableGetEmojiKeywordsDifference(this.identifier, this.langCode, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGetEmojiKeywordsDifference && this.equalTo(0, (ImmutableGetEmojiKeywordsDifference)another);
    }

    private boolean equalTo(int synthetic, ImmutableGetEmojiKeywordsDifference another) {
        return this.identifier == another.identifier && this.langCode.equals(another.langCode) && this.fromVersion == another.fromVersion;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.langCode.hashCode();
        h += (h << 5) + this.fromVersion;
        return h;
    }

    public String toString() {
        return "GetEmojiKeywordsDifference{identifier=" + this.identifier + ", langCode=" + this.langCode + ", fromVersion=" + this.fromVersion + "}";
    }

    public static ImmutableGetEmojiKeywordsDifference of(String langCode, int fromVersion) {
        return new ImmutableGetEmojiKeywordsDifference(langCode, fromVersion);
    }

    public static ImmutableGetEmojiKeywordsDifference copyOf(GetEmojiKeywordsDifference instance) {
        if (instance instanceof ImmutableGetEmojiKeywordsDifference) {
            return (ImmutableGetEmojiKeywordsDifference)instance;
        }
        return ImmutableGetEmojiKeywordsDifference.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_LANG_CODE = 1L;
        private static final long INIT_BIT_FROM_VERSION = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private String langCode;
        private int fromVersion;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(GetEmojiKeywordsDifference instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof GetEmojiKeywordsDifference) {
                instance = (GetEmojiKeywordsDifference)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.fromVersion(instance.fromVersion());
                this.langCode(instance.langCode());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder langCode(String langCode) {
            this.langCode = Objects.requireNonNull(langCode, "langCode");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder fromVersion(int fromVersion) {
            this.fromVersion = fromVersion;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableGetEmojiKeywordsDifference build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableGetEmojiKeywordsDifference(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("langCode");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("fromVersion");
            }
            return "Cannot build GetEmojiKeywordsDifference, some of required attributes are not set " + attributes;
        }
    }
}

