/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.messages;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.messages.GetEmojiKeywordsLanguages;

public final class ImmutableGetEmojiKeywordsLanguages
implements GetEmojiKeywordsLanguages {
    private final int identifier;
    private final List<String> langCodes;

    private ImmutableGetEmojiKeywordsLanguages(Builder builder) {
        this.langCodes = ImmutableGetEmojiKeywordsLanguages.createUnmodifiableList(true, builder.langCodes);
        this.identifier = builder.identifierIsSet() ? builder.identifier : GetEmojiKeywordsLanguages.super.identifier();
    }

    private ImmutableGetEmojiKeywordsLanguages(int identifier, List<String> langCodes) {
        this.identifier = identifier;
        this.langCodes = langCodes;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public List<String> langCodes() {
        return this.langCodes;
    }

    public final ImmutableGetEmojiKeywordsLanguages withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableGetEmojiKeywordsLanguages(value, this.langCodes);
    }

    public final ImmutableGetEmojiKeywordsLanguages withLangCodes(String ... elements) {
        List<String> newValue = ImmutableGetEmojiKeywordsLanguages.createUnmodifiableList(false, ImmutableGetEmojiKeywordsLanguages.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableGetEmojiKeywordsLanguages(this.identifier, newValue);
    }

    public final ImmutableGetEmojiKeywordsLanguages withLangCodes(Iterable<String> elements) {
        if (this.langCodes == elements) {
            return this;
        }
        List<String> newValue = ImmutableGetEmojiKeywordsLanguages.createUnmodifiableList(false, ImmutableGetEmojiKeywordsLanguages.createSafeList(elements, true, false));
        return new ImmutableGetEmojiKeywordsLanguages(this.identifier, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGetEmojiKeywordsLanguages && this.equalTo(0, (ImmutableGetEmojiKeywordsLanguages)another);
    }

    private boolean equalTo(int synthetic, ImmutableGetEmojiKeywordsLanguages another) {
        return this.identifier == another.identifier && this.langCodes.equals(another.langCodes);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.langCodes.hashCode();
        return h;
    }

    public String toString() {
        return "GetEmojiKeywordsLanguages{identifier=" + this.identifier + ", langCodes=" + this.langCodes + "}";
    }

    public static ImmutableGetEmojiKeywordsLanguages copyOf(GetEmojiKeywordsLanguages instance) {
        if (instance instanceof ImmutableGetEmojiKeywordsLanguages) {
            return (ImmutableGetEmojiKeywordsLanguages)instance;
        }
        return ImmutableGetEmojiKeywordsLanguages.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long optBits;
        private int identifier;
        private List<String> langCodes = new ArrayList<String>();

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(GetEmojiKeywordsLanguages instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof GetEmojiKeywordsLanguages) {
                instance = (GetEmojiKeywordsLanguages)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.addAllLangCodes(instance.langCodes());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder addLangCode(String element) {
            this.langCodes.add(Objects.requireNonNull(element, "langCodes element"));
            return this;
        }

        public final Builder addLangCodes(String ... elements) {
            for (String element : elements) {
                this.langCodes.add(Objects.requireNonNull(element, "langCodes element"));
            }
            return this;
        }

        public final Builder langCodes(Iterable<String> elements) {
            this.langCodes.clear();
            return this.addAllLangCodes(elements);
        }

        public final Builder addAllLangCodes(Iterable<String> elements) {
            for (String element : elements) {
                this.langCodes.add(Objects.requireNonNull(element, "langCodes element"));
            }
            return this;
        }

        public ImmutableGetEmojiKeywordsLanguages build() {
            return new ImmutableGetEmojiKeywordsLanguages(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }
}

