/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.messages;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputPeer;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.messages.GetExportedChatInvite;

public final class ImmutableGetExportedChatInvite
implements GetExportedChatInvite {
    private final int identifier;
    private final InputPeer peer;
    private final String link;

    private ImmutableGetExportedChatInvite(InputPeer peer, String link) {
        this.peer = Objects.requireNonNull(peer, "peer");
        this.link = Objects.requireNonNull(link, "link");
        this.identifier = GetExportedChatInvite.super.identifier();
    }

    private ImmutableGetExportedChatInvite(Builder builder) {
        this.peer = builder.peer;
        this.link = builder.link;
        this.identifier = builder.identifierIsSet() ? builder.identifier : GetExportedChatInvite.super.identifier();
    }

    private ImmutableGetExportedChatInvite(int identifier, InputPeer peer, String link) {
        this.identifier = identifier;
        this.peer = peer;
        this.link = link;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public InputPeer peer() {
        return this.peer;
    }

    @Override
    public String link() {
        return this.link;
    }

    public final ImmutableGetExportedChatInvite withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableGetExportedChatInvite(value, this.peer, this.link);
    }

    public final ImmutableGetExportedChatInvite withPeer(InputPeer value) {
        if (this.peer == value) {
            return this;
        }
        InputPeer newValue = Objects.requireNonNull(value, "peer");
        return new ImmutableGetExportedChatInvite(this.identifier, newValue, this.link);
    }

    public final ImmutableGetExportedChatInvite withLink(String value) {
        String newValue = Objects.requireNonNull(value, "link");
        if (this.link.equals(newValue)) {
            return this;
        }
        return new ImmutableGetExportedChatInvite(this.identifier, this.peer, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGetExportedChatInvite && this.equalTo(0, (ImmutableGetExportedChatInvite)another);
    }

    private boolean equalTo(int synthetic, ImmutableGetExportedChatInvite another) {
        return this.identifier == another.identifier && this.peer.equals(another.peer) && this.link.equals(another.link);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.peer.hashCode();
        h += (h << 5) + this.link.hashCode();
        return h;
    }

    public String toString() {
        return "GetExportedChatInvite{identifier=" + this.identifier + ", peer=" + this.peer + ", link=" + this.link + "}";
    }

    public static ImmutableGetExportedChatInvite of(InputPeer peer, String link) {
        return new ImmutableGetExportedChatInvite(peer, link);
    }

    public static ImmutableGetExportedChatInvite copyOf(GetExportedChatInvite instance) {
        if (instance instanceof ImmutableGetExportedChatInvite) {
            return (ImmutableGetExportedChatInvite)instance;
        }
        return ImmutableGetExportedChatInvite.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PEER = 1L;
        private static final long INIT_BIT_LINK = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private InputPeer peer;
        private String link;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(GetExportedChatInvite instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof GetExportedChatInvite) {
                instance = (GetExportedChatInvite)object;
                this.link(instance.link());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.peer(instance.peer());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder peer(InputPeer peer) {
            this.peer = Objects.requireNonNull(peer, "peer");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder link(String link) {
            this.link = Objects.requireNonNull(link, "link");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableGetExportedChatInvite build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableGetExportedChatInvite(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("peer");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("link");
            }
            return "Cannot build GetExportedChatInvite, some of required attributes are not set " + attributes;
        }
    }
}

