/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.messages;

import java.util.ArrayList;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.InputPeer;
import telegram4j.tl.InputUser;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.messages.GetExportedChatInvites;

public final class ImmutableGetExportedChatInvites
implements GetExportedChatInvites {
    private final int identifier;
    private final int flags;
    private final boolean revoked;
    private final InputPeer peer;
    private final InputUser adminId;
    @Nullable
    private final Integer offsetDate;
    @Nullable
    private final String offsetLink;
    private final int limit;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableGetExportedChatInvites(InputPeer peer, InputUser adminId, int limit) {
        this.peer = Objects.requireNonNull(peer, "peer");
        this.adminId = Objects.requireNonNull(adminId, "adminId");
        this.limit = limit;
        this.offsetDate = null;
        this.offsetLink = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.revoked = this.initShim.revoked();
        this.initShim = null;
    }

    private ImmutableGetExportedChatInvites(Builder builder) {
        this.peer = builder.peer;
        this.adminId = builder.adminId;
        this.offsetDate = builder.offsetDate;
        this.offsetLink = builder.offsetLink;
        this.limit = builder.limit;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.revokedIsSet()) {
            this.initShim.revoked(builder.revoked);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.revoked = this.initShim.revoked();
        this.initShim = null;
    }

    private ImmutableGetExportedChatInvites(int identifier, int flags, boolean revoked, InputPeer peer, InputUser adminId, @Nullable Integer offsetDate, @Nullable String offsetLink, int limit) {
        this.identifier = identifier;
        this.flags = flags;
        this.revoked = revoked;
        this.peer = peer;
        this.adminId = adminId;
        this.offsetDate = offsetDate;
        this.offsetLink = offsetLink;
        this.limit = limit;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return GetExportedChatInvites.super.identifier();
    }

    private int flagsInitialize() {
        return GetExportedChatInvites.super.flags();
    }

    private boolean revokedInitialize() {
        return GetExportedChatInvites.super.revoked();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean revoked() {
        InitShim shim = this.initShim;
        return shim != null ? shim.revoked() : this.revoked;
    }

    @Override
    public InputPeer peer() {
        return this.peer;
    }

    @Override
    public InputUser adminId() {
        return this.adminId;
    }

    @Override
    @Nullable
    public Integer offsetDate() {
        return this.offsetDate;
    }

    @Override
    @Nullable
    public String offsetLink() {
        return this.offsetLink;
    }

    @Override
    public int limit() {
        return this.limit;
    }

    public final ImmutableGetExportedChatInvites withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableGetExportedChatInvites(value, this.flags, this.revoked, this.peer, this.adminId, this.offsetDate, this.offsetLink, this.limit);
    }

    public final ImmutableGetExportedChatInvites withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableGetExportedChatInvites(this.identifier, value, this.revoked, this.peer, this.adminId, this.offsetDate, this.offsetLink, this.limit);
    }

    public final ImmutableGetExportedChatInvites withRevoked(boolean value) {
        if (this.revoked == value) {
            return this;
        }
        return new ImmutableGetExportedChatInvites(this.identifier, this.flags, value, this.peer, this.adminId, this.offsetDate, this.offsetLink, this.limit);
    }

    public final ImmutableGetExportedChatInvites withPeer(InputPeer value) {
        if (this.peer == value) {
            return this;
        }
        InputPeer newValue = Objects.requireNonNull(value, "peer");
        return new ImmutableGetExportedChatInvites(this.identifier, this.flags, this.revoked, newValue, this.adminId, this.offsetDate, this.offsetLink, this.limit);
    }

    public final ImmutableGetExportedChatInvites withAdminId(InputUser value) {
        if (this.adminId == value) {
            return this;
        }
        InputUser newValue = Objects.requireNonNull(value, "adminId");
        return new ImmutableGetExportedChatInvites(this.identifier, this.flags, this.revoked, this.peer, newValue, this.offsetDate, this.offsetLink, this.limit);
    }

    public final ImmutableGetExportedChatInvites withOffsetDate(@Nullable Integer value) {
        if (Objects.equals(this.offsetDate, value)) {
            return this;
        }
        return new ImmutableGetExportedChatInvites(this.identifier, this.flags, this.revoked, this.peer, this.adminId, value, this.offsetLink, this.limit);
    }

    public final ImmutableGetExportedChatInvites withOffsetLink(@Nullable String value) {
        if (Objects.equals(this.offsetLink, value)) {
            return this;
        }
        return new ImmutableGetExportedChatInvites(this.identifier, this.flags, this.revoked, this.peer, this.adminId, this.offsetDate, value, this.limit);
    }

    public final ImmutableGetExportedChatInvites withLimit(int value) {
        if (this.limit == value) {
            return this;
        }
        return new ImmutableGetExportedChatInvites(this.identifier, this.flags, this.revoked, this.peer, this.adminId, this.offsetDate, this.offsetLink, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGetExportedChatInvites && this.equalTo(0, (ImmutableGetExportedChatInvites)another);
    }

    private boolean equalTo(int synthetic, ImmutableGetExportedChatInvites another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.revoked == another.revoked && this.peer.equals(another.peer) && this.adminId.equals(another.adminId) && Objects.equals(this.offsetDate, another.offsetDate) && Objects.equals(this.offsetLink, another.offsetLink) && this.limit == another.limit;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.revoked);
        h += (h << 5) + this.peer.hashCode();
        h += (h << 5) + this.adminId.hashCode();
        h += (h << 5) + Objects.hashCode(this.offsetDate);
        h += (h << 5) + Objects.hashCode(this.offsetLink);
        h += (h << 5) + this.limit;
        return h;
    }

    public String toString() {
        return "GetExportedChatInvites{identifier=" + this.identifier + ", flags=" + this.flags + ", revoked=" + this.revoked + ", peer=" + this.peer + ", adminId=" + this.adminId + ", offsetDate=" + this.offsetDate + ", offsetLink=" + this.offsetLink + ", limit=" + this.limit + "}";
    }

    public static ImmutableGetExportedChatInvites of(InputPeer peer, InputUser adminId, int limit) {
        return new ImmutableGetExportedChatInvites(peer, adminId, limit);
    }

    public static ImmutableGetExportedChatInvites copyOf(GetExportedChatInvites instance) {
        if (instance instanceof ImmutableGetExportedChatInvites) {
            return (ImmutableGetExportedChatInvites)instance;
        }
        return ImmutableGetExportedChatInvites.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PEER = 1L;
        private static final long INIT_BIT_ADMIN_ID = 2L;
        private static final long INIT_BIT_LIMIT = 4L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_REVOKED = 4L;
        private long initBits = 7L;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean revoked;
        private InputPeer peer;
        private InputUser adminId;
        private Integer offsetDate;
        private String offsetLink;
        private int limit;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(GetExportedChatInvites instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof GetExportedChatInvites) {
                String offsetLinkValue;
                instance = (GetExportedChatInvites)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.peer(instance.peer());
                this.flags(instance.flags());
                this.adminId(instance.adminId());
                this.limit(instance.limit());
                this.revoked(instance.revoked());
                Integer offsetDateValue = instance.offsetDate();
                if (offsetDateValue != null) {
                    this.offsetDate(offsetDateValue);
                }
                if ((offsetLinkValue = instance.offsetLink()) != null) {
                    this.offsetLink(offsetLinkValue);
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder revoked(boolean revoked) {
            this.revoked = revoked;
            this.optBits |= 4L;
            return this;
        }

        public final Builder peer(InputPeer peer) {
            this.peer = Objects.requireNonNull(peer, "peer");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder adminId(InputUser adminId) {
            this.adminId = Objects.requireNonNull(adminId, "adminId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder offsetDate(@Nullable Integer offsetDate) {
            this.offsetDate = offsetDate;
            return this;
        }

        public final Builder offsetLink(@Nullable String offsetLink) {
            this.offsetLink = offsetLink;
            return this;
        }

        public final Builder limit(int limit) {
            this.limit = limit;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableGetExportedChatInvites build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableGetExportedChatInvites(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean revokedIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("peer");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("adminId");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("limit");
            }
            return "Cannot build GetExportedChatInvites, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte revokedBuildStage = 0;
        private boolean revoked;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableGetExportedChatInvites.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableGetExportedChatInvites.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean revoked() {
            if (this.revokedBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.revokedBuildStage == 0) {
                this.revokedBuildStage = (byte)-1;
                this.revoked = ImmutableGetExportedChatInvites.this.revokedInitialize();
                this.revokedBuildStage = 1;
            }
            return this.revoked;
        }

        void revoked(boolean revoked) {
            this.revoked = revoked;
            this.revokedBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.revokedBuildStage == -1) {
                attributes.add("revoked");
            }
            return "Cannot build GetExportedChatInvites, attribute initializers form cycle " + attributes;
        }
    }
}

