/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.messages;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.messages.GetFullChat;

public final class ImmutableGetFullChat
implements GetFullChat {
    private final int identifier;
    private final long chatId;

    private ImmutableGetFullChat(long chatId) {
        this.chatId = chatId;
        this.identifier = GetFullChat.super.identifier();
    }

    private ImmutableGetFullChat(Builder builder) {
        this.chatId = builder.chatId;
        this.identifier = builder.identifierIsSet() ? builder.identifier : GetFullChat.super.identifier();
    }

    private ImmutableGetFullChat(int identifier, long chatId) {
        this.identifier = identifier;
        this.chatId = chatId;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public long chatId() {
        return this.chatId;
    }

    public final ImmutableGetFullChat withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableGetFullChat(value, this.chatId);
    }

    public final ImmutableGetFullChat withChatId(long value) {
        if (this.chatId == value) {
            return this;
        }
        return new ImmutableGetFullChat(this.identifier, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGetFullChat && this.equalTo(0, (ImmutableGetFullChat)another);
    }

    private boolean equalTo(int synthetic, ImmutableGetFullChat another) {
        return this.identifier == another.identifier && this.chatId == another.chatId;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + Long.hashCode(this.chatId);
        return h;
    }

    public String toString() {
        return "GetFullChat{identifier=" + this.identifier + ", chatId=" + this.chatId + "}";
    }

    public static ImmutableGetFullChat of(long chatId) {
        return new ImmutableGetFullChat(chatId);
    }

    public static ImmutableGetFullChat copyOf(GetFullChat instance) {
        if (instance instanceof ImmutableGetFullChat) {
            return (ImmutableGetFullChat)instance;
        }
        return ImmutableGetFullChat.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_CHAT_ID = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private long chatId;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(GetFullChat instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof GetFullChat) {
                instance = (GetFullChat)object;
                this.chatId(instance.chatId());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder chatId(long chatId) {
            this.chatId = chatId;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableGetFullChat build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableGetFullChat(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("chatId");
            }
            return "Cannot build GetFullChat, some of required attributes are not set " + attributes;
        }
    }
}

