/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.messages;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputPeer;
import telegram4j.tl.InputUser;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.messages.GetGameHighScores;

public final class ImmutableGetGameHighScores
implements GetGameHighScores {
    private final int identifier;
    private final InputPeer peer;
    private final int id;
    private final InputUser userId;

    private ImmutableGetGameHighScores(InputPeer peer, int id, InputUser userId) {
        this.peer = Objects.requireNonNull(peer, "peer");
        this.id = id;
        this.userId = Objects.requireNonNull(userId, "userId");
        this.identifier = GetGameHighScores.super.identifier();
    }

    private ImmutableGetGameHighScores(Builder builder) {
        this.peer = builder.peer;
        this.id = builder.id;
        this.userId = builder.userId;
        this.identifier = builder.identifierIsSet() ? builder.identifier : GetGameHighScores.super.identifier();
    }

    private ImmutableGetGameHighScores(int identifier, InputPeer peer, int id, InputUser userId) {
        this.identifier = identifier;
        this.peer = peer;
        this.id = id;
        this.userId = userId;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public InputPeer peer() {
        return this.peer;
    }

    @Override
    public int id() {
        return this.id;
    }

    @Override
    public InputUser userId() {
        return this.userId;
    }

    public final ImmutableGetGameHighScores withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableGetGameHighScores(value, this.peer, this.id, this.userId);
    }

    public final ImmutableGetGameHighScores withPeer(InputPeer value) {
        if (this.peer == value) {
            return this;
        }
        InputPeer newValue = Objects.requireNonNull(value, "peer");
        return new ImmutableGetGameHighScores(this.identifier, newValue, this.id, this.userId);
    }

    public final ImmutableGetGameHighScores withId(int value) {
        if (this.id == value) {
            return this;
        }
        return new ImmutableGetGameHighScores(this.identifier, this.peer, value, this.userId);
    }

    public final ImmutableGetGameHighScores withUserId(InputUser value) {
        if (this.userId == value) {
            return this;
        }
        InputUser newValue = Objects.requireNonNull(value, "userId");
        return new ImmutableGetGameHighScores(this.identifier, this.peer, this.id, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGetGameHighScores && this.equalTo(0, (ImmutableGetGameHighScores)another);
    }

    private boolean equalTo(int synthetic, ImmutableGetGameHighScores another) {
        return this.identifier == another.identifier && this.peer.equals(another.peer) && this.id == another.id && this.userId.equals(another.userId);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.peer.hashCode();
        h += (h << 5) + this.id;
        h += (h << 5) + this.userId.hashCode();
        return h;
    }

    public String toString() {
        return "GetGameHighScores{identifier=" + this.identifier + ", peer=" + this.peer + ", id=" + this.id + ", userId=" + this.userId + "}";
    }

    public static ImmutableGetGameHighScores of(InputPeer peer, int id, InputUser userId) {
        return new ImmutableGetGameHighScores(peer, id, userId);
    }

    public static ImmutableGetGameHighScores copyOf(GetGameHighScores instance) {
        if (instance instanceof ImmutableGetGameHighScores) {
            return (ImmutableGetGameHighScores)instance;
        }
        return ImmutableGetGameHighScores.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PEER = 1L;
        private static final long INIT_BIT_ID = 2L;
        private static final long INIT_BIT_USER_ID = 4L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 7L;
        private long optBits;
        private int identifier;
        private InputPeer peer;
        private int id;
        private InputUser userId;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(GetGameHighScores instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof GetGameHighScores) {
                instance = (GetGameHighScores)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.id(instance.id());
                this.userId(instance.userId());
                this.peer(instance.peer());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder peer(InputPeer peer) {
            this.peer = Objects.requireNonNull(peer, "peer");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder id(int id) {
            this.id = id;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder userId(InputUser userId) {
            this.userId = Objects.requireNonNull(userId, "userId");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableGetGameHighScores build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableGetGameHighScores(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("peer");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("userId");
            }
            return "Cannot build GetGameHighScores, some of required attributes are not set " + attributes;
        }
    }
}

