/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.messages;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputPeer;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.messages.GetHistory;

public final class ImmutableGetHistory
implements GetHistory {
    private final int identifier;
    private final InputPeer peer;
    private final int offsetId;
    private final int offsetDate;
    private final int addOffset;
    private final int limit;
    private final int maxId;
    private final int minId;
    private final long hash;

    private ImmutableGetHistory(InputPeer peer, int offsetId, int offsetDate, int addOffset, int limit, int maxId, int minId, long hash) {
        this.peer = Objects.requireNonNull(peer, "peer");
        this.offsetId = offsetId;
        this.offsetDate = offsetDate;
        this.addOffset = addOffset;
        this.limit = limit;
        this.maxId = maxId;
        this.minId = minId;
        this.hash = hash;
        this.identifier = GetHistory.super.identifier();
    }

    private ImmutableGetHistory(Builder builder) {
        this.peer = builder.peer;
        this.offsetId = builder.offsetId;
        this.offsetDate = builder.offsetDate;
        this.addOffset = builder.addOffset;
        this.limit = builder.limit;
        this.maxId = builder.maxId;
        this.minId = builder.minId;
        this.hash = builder.hash;
        this.identifier = builder.identifierIsSet() ? builder.identifier : GetHistory.super.identifier();
    }

    private ImmutableGetHistory(int identifier, InputPeer peer, int offsetId, int offsetDate, int addOffset, int limit, int maxId, int minId, long hash) {
        this.identifier = identifier;
        this.peer = peer;
        this.offsetId = offsetId;
        this.offsetDate = offsetDate;
        this.addOffset = addOffset;
        this.limit = limit;
        this.maxId = maxId;
        this.minId = minId;
        this.hash = hash;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public InputPeer peer() {
        return this.peer;
    }

    @Override
    public int offsetId() {
        return this.offsetId;
    }

    @Override
    public int offsetDate() {
        return this.offsetDate;
    }

    @Override
    public int addOffset() {
        return this.addOffset;
    }

    @Override
    public int limit() {
        return this.limit;
    }

    @Override
    public int maxId() {
        return this.maxId;
    }

    @Override
    public int minId() {
        return this.minId;
    }

    @Override
    public long hash() {
        return this.hash;
    }

    public final ImmutableGetHistory withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableGetHistory(value, this.peer, this.offsetId, this.offsetDate, this.addOffset, this.limit, this.maxId, this.minId, this.hash);
    }

    public final ImmutableGetHistory withPeer(InputPeer value) {
        if (this.peer == value) {
            return this;
        }
        InputPeer newValue = Objects.requireNonNull(value, "peer");
        return new ImmutableGetHistory(this.identifier, newValue, this.offsetId, this.offsetDate, this.addOffset, this.limit, this.maxId, this.minId, this.hash);
    }

    public final ImmutableGetHistory withOffsetId(int value) {
        if (this.offsetId == value) {
            return this;
        }
        return new ImmutableGetHistory(this.identifier, this.peer, value, this.offsetDate, this.addOffset, this.limit, this.maxId, this.minId, this.hash);
    }

    public final ImmutableGetHistory withOffsetDate(int value) {
        if (this.offsetDate == value) {
            return this;
        }
        return new ImmutableGetHistory(this.identifier, this.peer, this.offsetId, value, this.addOffset, this.limit, this.maxId, this.minId, this.hash);
    }

    public final ImmutableGetHistory withAddOffset(int value) {
        if (this.addOffset == value) {
            return this;
        }
        return new ImmutableGetHistory(this.identifier, this.peer, this.offsetId, this.offsetDate, value, this.limit, this.maxId, this.minId, this.hash);
    }

    public final ImmutableGetHistory withLimit(int value) {
        if (this.limit == value) {
            return this;
        }
        return new ImmutableGetHistory(this.identifier, this.peer, this.offsetId, this.offsetDate, this.addOffset, value, this.maxId, this.minId, this.hash);
    }

    public final ImmutableGetHistory withMaxId(int value) {
        if (this.maxId == value) {
            return this;
        }
        return new ImmutableGetHistory(this.identifier, this.peer, this.offsetId, this.offsetDate, this.addOffset, this.limit, value, this.minId, this.hash);
    }

    public final ImmutableGetHistory withMinId(int value) {
        if (this.minId == value) {
            return this;
        }
        return new ImmutableGetHistory(this.identifier, this.peer, this.offsetId, this.offsetDate, this.addOffset, this.limit, this.maxId, value, this.hash);
    }

    public final ImmutableGetHistory withHash(long value) {
        if (this.hash == value) {
            return this;
        }
        return new ImmutableGetHistory(this.identifier, this.peer, this.offsetId, this.offsetDate, this.addOffset, this.limit, this.maxId, this.minId, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGetHistory && this.equalTo(0, (ImmutableGetHistory)another);
    }

    private boolean equalTo(int synthetic, ImmutableGetHistory another) {
        return this.identifier == another.identifier && this.peer.equals(another.peer) && this.offsetId == another.offsetId && this.offsetDate == another.offsetDate && this.addOffset == another.addOffset && this.limit == another.limit && this.maxId == another.maxId && this.minId == another.minId && this.hash == another.hash;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.peer.hashCode();
        h += (h << 5) + this.offsetId;
        h += (h << 5) + this.offsetDate;
        h += (h << 5) + this.addOffset;
        h += (h << 5) + this.limit;
        h += (h << 5) + this.maxId;
        h += (h << 5) + this.minId;
        h += (h << 5) + Long.hashCode(this.hash);
        return h;
    }

    public String toString() {
        return "GetHistory{identifier=" + this.identifier + ", peer=" + this.peer + ", offsetId=" + this.offsetId + ", offsetDate=" + this.offsetDate + ", addOffset=" + this.addOffset + ", limit=" + this.limit + ", maxId=" + this.maxId + ", minId=" + this.minId + ", hash=" + this.hash + "}";
    }

    public static ImmutableGetHistory of(InputPeer peer, int offsetId, int offsetDate, int addOffset, int limit, int maxId, int minId, long hash) {
        return new ImmutableGetHistory(peer, offsetId, offsetDate, addOffset, limit, maxId, minId, hash);
    }

    public static ImmutableGetHistory copyOf(GetHistory instance) {
        if (instance instanceof ImmutableGetHistory) {
            return (ImmutableGetHistory)instance;
        }
        return ImmutableGetHistory.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PEER = 1L;
        private static final long INIT_BIT_OFFSET_ID = 2L;
        private static final long INIT_BIT_OFFSET_DATE = 4L;
        private static final long INIT_BIT_ADD_OFFSET = 8L;
        private static final long INIT_BIT_LIMIT = 16L;
        private static final long INIT_BIT_MAX_ID = 32L;
        private static final long INIT_BIT_MIN_ID = 64L;
        private static final long INIT_BIT_HASH = 128L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 255L;
        private long optBits;
        private int identifier;
        private InputPeer peer;
        private int offsetId;
        private int offsetDate;
        private int addOffset;
        private int limit;
        private int maxId;
        private int minId;
        private long hash;

        private Builder() {
        }

        public final Builder from(GetHistory instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            GetHistory instance;
            long bits = 0L;
            if (object instanceof GetHistory) {
                instance = (GetHistory)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.maxId(instance.maxId());
                this.peer(instance.peer());
                this.limit(instance.limit());
                this.addOffset(instance.addOffset());
                this.offsetDate(instance.offsetDate());
                this.minId(instance.minId());
                this.offsetId(instance.offsetId());
                this.hash(instance.hash());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder peer(InputPeer peer) {
            this.peer = Objects.requireNonNull(peer, "peer");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder offsetId(int offsetId) {
            this.offsetId = offsetId;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder offsetDate(int offsetDate) {
            this.offsetDate = offsetDate;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder addOffset(int addOffset) {
            this.addOffset = addOffset;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder limit(int limit) {
            this.limit = limit;
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public final Builder maxId(int maxId) {
            this.maxId = maxId;
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        public final Builder minId(int minId) {
            this.minId = minId;
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        public final Builder hash(long hash) {
            this.hash = hash;
            this.initBits &= 0xFFFFFFFFFFFFFF7FL;
            return this;
        }

        public ImmutableGetHistory build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableGetHistory(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("peer");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("offsetId");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("offsetDate");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("addOffset");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("limit");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("maxId");
            }
            if ((this.initBits & 0x40L) != 0L) {
                attributes.add("minId");
            }
            if ((this.initBits & 0x80L) != 0L) {
                attributes.add("hash");
            }
            return "Cannot build GetHistory, some of required attributes are not set " + attributes;
        }
    }
}

