/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.messages;

import java.util.ArrayList;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.InputGeoPoint;
import telegram4j.tl.InputPeer;
import telegram4j.tl.InputUser;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.messages.GetInlineBotResults;

public final class ImmutableGetInlineBotResults
implements GetInlineBotResults {
    private final int identifier;
    private final int flags;
    private final InputUser bot;
    private final InputPeer peer;
    @Nullable
    private final InputGeoPoint geoPoint;
    private final String query;
    private final String offset;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableGetInlineBotResults(InputUser bot, InputPeer peer, String query, String offset) {
        this.bot = Objects.requireNonNull(bot, "bot");
        this.peer = Objects.requireNonNull(peer, "peer");
        this.query = Objects.requireNonNull(query, "query");
        this.offset = Objects.requireNonNull(offset, "offset");
        this.geoPoint = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableGetInlineBotResults(Builder builder) {
        this.bot = builder.bot;
        this.peer = builder.peer;
        this.geoPoint = builder.geoPoint;
        this.query = builder.query;
        this.offset = builder.offset;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableGetInlineBotResults(int identifier, int flags, InputUser bot, InputPeer peer, @Nullable InputGeoPoint geoPoint, String query, String offset) {
        this.identifier = identifier;
        this.flags = flags;
        this.bot = bot;
        this.peer = peer;
        this.geoPoint = geoPoint;
        this.query = query;
        this.offset = offset;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return GetInlineBotResults.super.identifier();
    }

    private int flagsInitialize() {
        return GetInlineBotResults.super.flags();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public InputUser bot() {
        return this.bot;
    }

    @Override
    public InputPeer peer() {
        return this.peer;
    }

    @Override
    @Nullable
    public InputGeoPoint geoPoint() {
        return this.geoPoint;
    }

    @Override
    public String query() {
        return this.query;
    }

    @Override
    public String offset() {
        return this.offset;
    }

    public final ImmutableGetInlineBotResults withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableGetInlineBotResults(value, this.flags, this.bot, this.peer, this.geoPoint, this.query, this.offset);
    }

    public final ImmutableGetInlineBotResults withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableGetInlineBotResults(this.identifier, value, this.bot, this.peer, this.geoPoint, this.query, this.offset);
    }

    public final ImmutableGetInlineBotResults withBot(InputUser value) {
        if (this.bot == value) {
            return this;
        }
        InputUser newValue = Objects.requireNonNull(value, "bot");
        return new ImmutableGetInlineBotResults(this.identifier, this.flags, newValue, this.peer, this.geoPoint, this.query, this.offset);
    }

    public final ImmutableGetInlineBotResults withPeer(InputPeer value) {
        if (this.peer == value) {
            return this;
        }
        InputPeer newValue = Objects.requireNonNull(value, "peer");
        return new ImmutableGetInlineBotResults(this.identifier, this.flags, this.bot, newValue, this.geoPoint, this.query, this.offset);
    }

    public final ImmutableGetInlineBotResults withGeoPoint(@Nullable InputGeoPoint value) {
        if (this.geoPoint == value) {
            return this;
        }
        return new ImmutableGetInlineBotResults(this.identifier, this.flags, this.bot, this.peer, value, this.query, this.offset);
    }

    public final ImmutableGetInlineBotResults withQuery(String value) {
        String newValue = Objects.requireNonNull(value, "query");
        if (this.query.equals(newValue)) {
            return this;
        }
        return new ImmutableGetInlineBotResults(this.identifier, this.flags, this.bot, this.peer, this.geoPoint, newValue, this.offset);
    }

    public final ImmutableGetInlineBotResults withOffset(String value) {
        String newValue = Objects.requireNonNull(value, "offset");
        if (this.offset.equals(newValue)) {
            return this;
        }
        return new ImmutableGetInlineBotResults(this.identifier, this.flags, this.bot, this.peer, this.geoPoint, this.query, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGetInlineBotResults && this.equalTo(0, (ImmutableGetInlineBotResults)another);
    }

    private boolean equalTo(int synthetic, ImmutableGetInlineBotResults another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.bot.equals(another.bot) && this.peer.equals(another.peer) && Objects.equals(this.geoPoint, another.geoPoint) && this.query.equals(another.query) && this.offset.equals(another.offset);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + this.bot.hashCode();
        h += (h << 5) + this.peer.hashCode();
        h += (h << 5) + Objects.hashCode(this.geoPoint);
        h += (h << 5) + this.query.hashCode();
        h += (h << 5) + this.offset.hashCode();
        return h;
    }

    public String toString() {
        return "GetInlineBotResults{identifier=" + this.identifier + ", flags=" + this.flags + ", bot=" + this.bot + ", peer=" + this.peer + ", geoPoint=" + this.geoPoint + ", query=" + this.query + ", offset=" + this.offset + "}";
    }

    public static ImmutableGetInlineBotResults of(InputUser bot, InputPeer peer, String query, String offset) {
        return new ImmutableGetInlineBotResults(bot, peer, query, offset);
    }

    public static ImmutableGetInlineBotResults copyOf(GetInlineBotResults instance) {
        if (instance instanceof ImmutableGetInlineBotResults) {
            return (ImmutableGetInlineBotResults)instance;
        }
        return ImmutableGetInlineBotResults.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_BOT = 1L;
        private static final long INIT_BIT_PEER = 2L;
        private static final long INIT_BIT_QUERY = 4L;
        private static final long INIT_BIT_OFFSET = 8L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private long initBits = 15L;
        private long optBits;
        private int identifier;
        private int flags;
        private InputUser bot;
        private InputPeer peer;
        private InputGeoPoint geoPoint;
        private String query;
        private String offset;

        private Builder() {
        }

        public final Builder from(GetInlineBotResults instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            GetInlineBotResults instance;
            long bits = 0L;
            if (object instanceof GetInlineBotResults) {
                instance = (GetInlineBotResults)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.offset(instance.offset());
                this.bot(instance.bot());
                this.peer(instance.peer());
                this.query(instance.query());
                this.flags(instance.flags());
                InputGeoPoint geoPointValue = instance.geoPoint();
                if (geoPointValue != null) {
                    this.geoPoint(geoPointValue);
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder bot(InputUser bot) {
            this.bot = Objects.requireNonNull(bot, "bot");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder peer(InputPeer peer) {
            this.peer = Objects.requireNonNull(peer, "peer");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder geoPoint(@Nullable InputGeoPoint geoPoint) {
            this.geoPoint = geoPoint;
            return this;
        }

        public final Builder query(String query) {
            this.query = Objects.requireNonNull(query, "query");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder offset(String offset) {
            this.offset = Objects.requireNonNull(offset, "offset");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public ImmutableGetInlineBotResults build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableGetInlineBotResults(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("bot");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("peer");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("query");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("offset");
            }
            return "Cannot build GetInlineBotResults, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableGetInlineBotResults.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableGetInlineBotResults.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            return "Cannot build GetInlineBotResults, attribute initializers form cycle " + attributes;
        }
    }
}

