/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.messages;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.messages.GetMaskStickers;

public final class ImmutableGetMaskStickers
implements GetMaskStickers {
    private final int identifier;
    private final long hash;

    private ImmutableGetMaskStickers(long hash) {
        this.hash = hash;
        this.identifier = GetMaskStickers.super.identifier();
    }

    private ImmutableGetMaskStickers(Builder builder) {
        this.hash = builder.hash;
        this.identifier = builder.identifierIsSet() ? builder.identifier : GetMaskStickers.super.identifier();
    }

    private ImmutableGetMaskStickers(int identifier, long hash) {
        this.identifier = identifier;
        this.hash = hash;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public long hash() {
        return this.hash;
    }

    public final ImmutableGetMaskStickers withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableGetMaskStickers(value, this.hash);
    }

    public final ImmutableGetMaskStickers withHash(long value) {
        if (this.hash == value) {
            return this;
        }
        return new ImmutableGetMaskStickers(this.identifier, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGetMaskStickers && this.equalTo(0, (ImmutableGetMaskStickers)another);
    }

    private boolean equalTo(int synthetic, ImmutableGetMaskStickers another) {
        return this.identifier == another.identifier && this.hash == another.hash;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + Long.hashCode(this.hash);
        return h;
    }

    public String toString() {
        return "GetMaskStickers{identifier=" + this.identifier + ", hash=" + this.hash + "}";
    }

    public static ImmutableGetMaskStickers of(long hash) {
        return new ImmutableGetMaskStickers(hash);
    }

    public static ImmutableGetMaskStickers copyOf(GetMaskStickers instance) {
        if (instance instanceof ImmutableGetMaskStickers) {
            return (ImmutableGetMaskStickers)instance;
        }
        return ImmutableGetMaskStickers.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_HASH = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private long hash;

        private Builder() {
        }

        public final Builder from(GetMaskStickers instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            GetMaskStickers instance;
            long bits = 0L;
            if (object instanceof GetMaskStickers) {
                instance = (GetMaskStickers)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.hash(instance.hash());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder hash(long hash) {
            this.hash = hash;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableGetMaskStickers build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableGetMaskStickers(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("hash");
            }
            return "Cannot build GetMaskStickers, some of required attributes are not set " + attributes;
        }
    }
}

