/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.messages;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputPeer;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.messages.GetMessageEditData;

public final class ImmutableGetMessageEditData
implements GetMessageEditData {
    private final int identifier;
    private final InputPeer peer;
    private final int id;

    private ImmutableGetMessageEditData(InputPeer peer, int id) {
        this.peer = Objects.requireNonNull(peer, "peer");
        this.id = id;
        this.identifier = GetMessageEditData.super.identifier();
    }

    private ImmutableGetMessageEditData(Builder builder) {
        this.peer = builder.peer;
        this.id = builder.id;
        this.identifier = builder.identifierIsSet() ? builder.identifier : GetMessageEditData.super.identifier();
    }

    private ImmutableGetMessageEditData(int identifier, InputPeer peer, int id) {
        this.identifier = identifier;
        this.peer = peer;
        this.id = id;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public InputPeer peer() {
        return this.peer;
    }

    @Override
    public int id() {
        return this.id;
    }

    public final ImmutableGetMessageEditData withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableGetMessageEditData(value, this.peer, this.id);
    }

    public final ImmutableGetMessageEditData withPeer(InputPeer value) {
        if (this.peer == value) {
            return this;
        }
        InputPeer newValue = Objects.requireNonNull(value, "peer");
        return new ImmutableGetMessageEditData(this.identifier, newValue, this.id);
    }

    public final ImmutableGetMessageEditData withId(int value) {
        if (this.id == value) {
            return this;
        }
        return new ImmutableGetMessageEditData(this.identifier, this.peer, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGetMessageEditData && this.equalTo(0, (ImmutableGetMessageEditData)another);
    }

    private boolean equalTo(int synthetic, ImmutableGetMessageEditData another) {
        return this.identifier == another.identifier && this.peer.equals(another.peer) && this.id == another.id;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.peer.hashCode();
        h += (h << 5) + this.id;
        return h;
    }

    public String toString() {
        return "GetMessageEditData{identifier=" + this.identifier + ", peer=" + this.peer + ", id=" + this.id + "}";
    }

    public static ImmutableGetMessageEditData of(InputPeer peer, int id) {
        return new ImmutableGetMessageEditData(peer, id);
    }

    public static ImmutableGetMessageEditData copyOf(GetMessageEditData instance) {
        if (instance instanceof ImmutableGetMessageEditData) {
            return (ImmutableGetMessageEditData)instance;
        }
        return ImmutableGetMessageEditData.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PEER = 1L;
        private static final long INIT_BIT_ID = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private InputPeer peer;
        private int id;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(GetMessageEditData instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof GetMessageEditData) {
                instance = (GetMessageEditData)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.peer(instance.peer());
                this.id(instance.id());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder peer(InputPeer peer) {
            this.peer = Objects.requireNonNull(peer, "peer");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder id(int id) {
            this.id = id;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableGetMessageEditData build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableGetMessageEditData(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("peer");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("id");
            }
            return "Cannot build GetMessageEditData, some of required attributes are not set " + attributes;
        }
    }
}

