/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.messages;

import java.util.ArrayList;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.InputPeer;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.messages.GetMessageReactionsList;

public final class ImmutableGetMessageReactionsList
implements GetMessageReactionsList {
    private final int identifier;
    private final int flags;
    private final InputPeer peer;
    private final int id;
    @Nullable
    private final String reaction;
    @Nullable
    private final String offset;
    private final int limit;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableGetMessageReactionsList(InputPeer peer, int id, int limit) {
        this.peer = Objects.requireNonNull(peer, "peer");
        this.id = id;
        this.limit = limit;
        this.reaction = null;
        this.offset = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableGetMessageReactionsList(Builder builder) {
        this.peer = builder.peer;
        this.id = builder.id;
        this.reaction = builder.reaction;
        this.offset = builder.offset;
        this.limit = builder.limit;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableGetMessageReactionsList(int identifier, int flags, InputPeer peer, int id, @Nullable String reaction, @Nullable String offset, int limit) {
        this.identifier = identifier;
        this.flags = flags;
        this.peer = peer;
        this.id = id;
        this.reaction = reaction;
        this.offset = offset;
        this.limit = limit;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return GetMessageReactionsList.super.identifier();
    }

    private int flagsInitialize() {
        return GetMessageReactionsList.super.flags();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public InputPeer peer() {
        return this.peer;
    }

    @Override
    public int id() {
        return this.id;
    }

    @Override
    @Nullable
    public String reaction() {
        return this.reaction;
    }

    @Override
    @Nullable
    public String offset() {
        return this.offset;
    }

    @Override
    public int limit() {
        return this.limit;
    }

    public final ImmutableGetMessageReactionsList withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableGetMessageReactionsList(value, this.flags, this.peer, this.id, this.reaction, this.offset, this.limit);
    }

    public final ImmutableGetMessageReactionsList withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableGetMessageReactionsList(this.identifier, value, this.peer, this.id, this.reaction, this.offset, this.limit);
    }

    public final ImmutableGetMessageReactionsList withPeer(InputPeer value) {
        if (this.peer == value) {
            return this;
        }
        InputPeer newValue = Objects.requireNonNull(value, "peer");
        return new ImmutableGetMessageReactionsList(this.identifier, this.flags, newValue, this.id, this.reaction, this.offset, this.limit);
    }

    public final ImmutableGetMessageReactionsList withId(int value) {
        if (this.id == value) {
            return this;
        }
        return new ImmutableGetMessageReactionsList(this.identifier, this.flags, this.peer, value, this.reaction, this.offset, this.limit);
    }

    public final ImmutableGetMessageReactionsList withReaction(@Nullable String value) {
        if (Objects.equals(this.reaction, value)) {
            return this;
        }
        return new ImmutableGetMessageReactionsList(this.identifier, this.flags, this.peer, this.id, value, this.offset, this.limit);
    }

    public final ImmutableGetMessageReactionsList withOffset(@Nullable String value) {
        if (Objects.equals(this.offset, value)) {
            return this;
        }
        return new ImmutableGetMessageReactionsList(this.identifier, this.flags, this.peer, this.id, this.reaction, value, this.limit);
    }

    public final ImmutableGetMessageReactionsList withLimit(int value) {
        if (this.limit == value) {
            return this;
        }
        return new ImmutableGetMessageReactionsList(this.identifier, this.flags, this.peer, this.id, this.reaction, this.offset, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGetMessageReactionsList && this.equalTo(0, (ImmutableGetMessageReactionsList)another);
    }

    private boolean equalTo(int synthetic, ImmutableGetMessageReactionsList another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.peer.equals(another.peer) && this.id == another.id && Objects.equals(this.reaction, another.reaction) && Objects.equals(this.offset, another.offset) && this.limit == another.limit;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + this.peer.hashCode();
        h += (h << 5) + this.id;
        h += (h << 5) + Objects.hashCode(this.reaction);
        h += (h << 5) + Objects.hashCode(this.offset);
        h += (h << 5) + this.limit;
        return h;
    }

    public String toString() {
        return "GetMessageReactionsList{identifier=" + this.identifier + ", flags=" + this.flags + ", peer=" + this.peer + ", id=" + this.id + ", reaction=" + this.reaction + ", offset=" + this.offset + ", limit=" + this.limit + "}";
    }

    public static ImmutableGetMessageReactionsList of(InputPeer peer, int id, int limit) {
        return new ImmutableGetMessageReactionsList(peer, id, limit);
    }

    public static ImmutableGetMessageReactionsList copyOf(GetMessageReactionsList instance) {
        if (instance instanceof ImmutableGetMessageReactionsList) {
            return (ImmutableGetMessageReactionsList)instance;
        }
        return ImmutableGetMessageReactionsList.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PEER = 1L;
        private static final long INIT_BIT_ID = 2L;
        private static final long INIT_BIT_LIMIT = 4L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private long initBits = 7L;
        private long optBits;
        private int identifier;
        private int flags;
        private InputPeer peer;
        private int id;
        private String reaction;
        private String offset;
        private int limit;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(GetMessageReactionsList instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof GetMessageReactionsList) {
                String offsetValue;
                String reactionValue;
                instance = (GetMessageReactionsList)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((reactionValue = instance.reaction()) != null) {
                    this.reaction(reactionValue);
                }
                if ((offsetValue = instance.offset()) != null) {
                    this.offset(offsetValue);
                }
                this.peer(instance.peer());
                this.flags(instance.flags());
                this.limit(instance.limit());
                this.id(instance.id());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder peer(InputPeer peer) {
            this.peer = Objects.requireNonNull(peer, "peer");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder id(int id) {
            this.id = id;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder reaction(@Nullable String reaction) {
            this.reaction = reaction;
            return this;
        }

        public final Builder offset(@Nullable String offset) {
            this.offset = offset;
            return this;
        }

        public final Builder limit(int limit) {
            this.limit = limit;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableGetMessageReactionsList build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableGetMessageReactionsList(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("peer");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("limit");
            }
            return "Cannot build GetMessageReactionsList, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableGetMessageReactionsList.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableGetMessageReactionsList.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            return "Cannot build GetMessageReactionsList, attribute initializers form cycle " + attributes;
        }
    }
}

