/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.messages;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import telegram4j.tl.InputMessage;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.messages.GetMessages;

public final class ImmutableGetMessages
implements GetMessages {
    private final int identifier;
    private final List<InputMessage> id;

    private ImmutableGetMessages(Builder builder) {
        this.id = ImmutableGetMessages.createUnmodifiableList(true, builder.id);
        this.identifier = builder.identifierIsSet() ? builder.identifier : GetMessages.super.identifier();
    }

    private ImmutableGetMessages(int identifier, List<InputMessage> id) {
        this.identifier = identifier;
        this.id = id;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public List<InputMessage> id() {
        return this.id;
    }

    public final ImmutableGetMessages withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableGetMessages(value, this.id);
    }

    public final ImmutableGetMessages withId(InputMessage ... elements) {
        List<InputMessage> newValue = ImmutableGetMessages.createUnmodifiableList(false, ImmutableGetMessages.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableGetMessages(this.identifier, newValue);
    }

    public final ImmutableGetMessages withId(Iterable<? extends InputMessage> elements) {
        if (this.id == elements) {
            return this;
        }
        List<InputMessage> newValue = ImmutableGetMessages.createUnmodifiableList(false, ImmutableGetMessages.createSafeList(elements, true, false));
        return new ImmutableGetMessages(this.identifier, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGetMessages && this.equalTo(0, (ImmutableGetMessages)another);
    }

    private boolean equalTo(int synthetic, ImmutableGetMessages another) {
        return this.identifier == another.identifier && this.id.equals(another.id);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.id.hashCode();
        return h;
    }

    public String toString() {
        return "GetMessages{identifier=" + this.identifier + ", id=" + this.id + "}";
    }

    public static ImmutableGetMessages copyOf(GetMessages instance) {
        if (instance instanceof ImmutableGetMessages) {
            return (ImmutableGetMessages)instance;
        }
        return ImmutableGetMessages.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long optBits;
        private int identifier;
        private List<InputMessage> id = new ArrayList<InputMessage>();

        private Builder() {
        }

        public final Builder from(GetMessages instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            GetMessages instance;
            long bits = 0L;
            if (object instanceof GetMessages) {
                instance = (GetMessages)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.addAllId(instance.id());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder addId(InputMessage element) {
            this.id.add(Objects.requireNonNull(element, "id element"));
            return this;
        }

        public final Builder addId(InputMessage ... elements) {
            for (InputMessage element : elements) {
                this.id.add(Objects.requireNonNull(element, "id element"));
            }
            return this;
        }

        public final Builder id(Iterable<? extends InputMessage> elements) {
            this.id.clear();
            return this.addAllId(elements);
        }

        public final Builder addAllId(Iterable<? extends InputMessage> elements) {
            for (InputMessage inputMessage : elements) {
                this.id.add(Objects.requireNonNull(inputMessage, "id element"));
            }
            return this;
        }

        public ImmutableGetMessages build() {
            return new ImmutableGetMessages(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }
}

