/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.messages;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.messages.GetOldFeaturedStickers;

public final class ImmutableGetOldFeaturedStickers
implements GetOldFeaturedStickers {
    private final int identifier;
    private final int offset;
    private final int limit;
    private final long hash;

    private ImmutableGetOldFeaturedStickers(int offset, int limit, long hash) {
        this.offset = offset;
        this.limit = limit;
        this.hash = hash;
        this.identifier = GetOldFeaturedStickers.super.identifier();
    }

    private ImmutableGetOldFeaturedStickers(Builder builder) {
        this.offset = builder.offset;
        this.limit = builder.limit;
        this.hash = builder.hash;
        this.identifier = builder.identifierIsSet() ? builder.identifier : GetOldFeaturedStickers.super.identifier();
    }

    private ImmutableGetOldFeaturedStickers(int identifier, int offset, int limit, long hash) {
        this.identifier = identifier;
        this.offset = offset;
        this.limit = limit;
        this.hash = hash;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public int offset() {
        return this.offset;
    }

    @Override
    public int limit() {
        return this.limit;
    }

    @Override
    public long hash() {
        return this.hash;
    }

    public final ImmutableGetOldFeaturedStickers withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableGetOldFeaturedStickers(value, this.offset, this.limit, this.hash);
    }

    public final ImmutableGetOldFeaturedStickers withOffset(int value) {
        if (this.offset == value) {
            return this;
        }
        return new ImmutableGetOldFeaturedStickers(this.identifier, value, this.limit, this.hash);
    }

    public final ImmutableGetOldFeaturedStickers withLimit(int value) {
        if (this.limit == value) {
            return this;
        }
        return new ImmutableGetOldFeaturedStickers(this.identifier, this.offset, value, this.hash);
    }

    public final ImmutableGetOldFeaturedStickers withHash(long value) {
        if (this.hash == value) {
            return this;
        }
        return new ImmutableGetOldFeaturedStickers(this.identifier, this.offset, this.limit, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGetOldFeaturedStickers && this.equalTo(0, (ImmutableGetOldFeaturedStickers)another);
    }

    private boolean equalTo(int synthetic, ImmutableGetOldFeaturedStickers another) {
        return this.identifier == another.identifier && this.offset == another.offset && this.limit == another.limit && this.hash == another.hash;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.offset;
        h += (h << 5) + this.limit;
        h += (h << 5) + Long.hashCode(this.hash);
        return h;
    }

    public String toString() {
        return "GetOldFeaturedStickers{identifier=" + this.identifier + ", offset=" + this.offset + ", limit=" + this.limit + ", hash=" + this.hash + "}";
    }

    public static ImmutableGetOldFeaturedStickers of(int offset, int limit, long hash) {
        return new ImmutableGetOldFeaturedStickers(offset, limit, hash);
    }

    public static ImmutableGetOldFeaturedStickers copyOf(GetOldFeaturedStickers instance) {
        if (instance instanceof ImmutableGetOldFeaturedStickers) {
            return (ImmutableGetOldFeaturedStickers)instance;
        }
        return ImmutableGetOldFeaturedStickers.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_OFFSET = 1L;
        private static final long INIT_BIT_LIMIT = 2L;
        private static final long INIT_BIT_HASH = 4L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 7L;
        private long optBits;
        private int identifier;
        private int offset;
        private int limit;
        private long hash;

        private Builder() {
        }

        public final Builder from(GetOldFeaturedStickers instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            GetOldFeaturedStickers instance;
            long bits = 0L;
            if (object instanceof GetOldFeaturedStickers) {
                instance = (GetOldFeaturedStickers)object;
                this.limit(instance.limit());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.offset(instance.offset());
                this.hash(instance.hash());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder offset(int offset) {
            this.offset = offset;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder limit(int limit) {
            this.limit = limit;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder hash(long hash) {
            this.hash = hash;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableGetOldFeaturedStickers build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableGetOldFeaturedStickers(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("offset");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("limit");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("hash");
            }
            return "Cannot build GetOldFeaturedStickers, some of required attributes are not set " + attributes;
        }
    }
}

