/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.messages;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import telegram4j.tl.InputDialogPeer;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.messages.GetPeerDialogs;

public final class ImmutableGetPeerDialogs
implements GetPeerDialogs {
    private final int identifier;
    private final List<InputDialogPeer> peers;

    private ImmutableGetPeerDialogs(Builder builder) {
        this.peers = ImmutableGetPeerDialogs.createUnmodifiableList(true, builder.peers);
        this.identifier = builder.identifierIsSet() ? builder.identifier : GetPeerDialogs.super.identifier();
    }

    private ImmutableGetPeerDialogs(int identifier, List<InputDialogPeer> peers) {
        this.identifier = identifier;
        this.peers = peers;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public List<InputDialogPeer> peers() {
        return this.peers;
    }

    public final ImmutableGetPeerDialogs withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableGetPeerDialogs(value, this.peers);
    }

    public final ImmutableGetPeerDialogs withPeers(InputDialogPeer ... elements) {
        List<InputDialogPeer> newValue = ImmutableGetPeerDialogs.createUnmodifiableList(false, ImmutableGetPeerDialogs.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableGetPeerDialogs(this.identifier, newValue);
    }

    public final ImmutableGetPeerDialogs withPeers(Iterable<? extends InputDialogPeer> elements) {
        if (this.peers == elements) {
            return this;
        }
        List<InputDialogPeer> newValue = ImmutableGetPeerDialogs.createUnmodifiableList(false, ImmutableGetPeerDialogs.createSafeList(elements, true, false));
        return new ImmutableGetPeerDialogs(this.identifier, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGetPeerDialogs && this.equalTo(0, (ImmutableGetPeerDialogs)another);
    }

    private boolean equalTo(int synthetic, ImmutableGetPeerDialogs another) {
        return this.identifier == another.identifier && this.peers.equals(another.peers);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.peers.hashCode();
        return h;
    }

    public String toString() {
        return "GetPeerDialogs{identifier=" + this.identifier + ", peers=" + this.peers + "}";
    }

    public static ImmutableGetPeerDialogs copyOf(GetPeerDialogs instance) {
        if (instance instanceof ImmutableGetPeerDialogs) {
            return (ImmutableGetPeerDialogs)instance;
        }
        return ImmutableGetPeerDialogs.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long optBits;
        private int identifier;
        private List<InputDialogPeer> peers = new ArrayList<InputDialogPeer>();

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(GetPeerDialogs instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof GetPeerDialogs) {
                instance = (GetPeerDialogs)object;
                this.addAllPeers(instance.peers());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder addPeer(InputDialogPeer element) {
            this.peers.add(Objects.requireNonNull(element, "peers element"));
            return this;
        }

        public final Builder addPeers(InputDialogPeer ... elements) {
            for (InputDialogPeer element : elements) {
                this.peers.add(Objects.requireNonNull(element, "peers element"));
            }
            return this;
        }

        public final Builder peers(Iterable<? extends InputDialogPeer> elements) {
            this.peers.clear();
            return this.addAllPeers(elements);
        }

        public final Builder addAllPeers(Iterable<? extends InputDialogPeer> elements) {
            for (InputDialogPeer inputDialogPeer : elements) {
                this.peers.add(Objects.requireNonNull(inputDialogPeer, "peers element"));
            }
            return this;
        }

        public ImmutableGetPeerDialogs build() {
            return new ImmutableGetPeerDialogs(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }
}

