/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.messages;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.messages.GetPinnedDialogs;

public final class ImmutableGetPinnedDialogs
implements GetPinnedDialogs {
    private final int identifier;
    private final int folderId;

    private ImmutableGetPinnedDialogs(int folderId) {
        this.folderId = folderId;
        this.identifier = GetPinnedDialogs.super.identifier();
    }

    private ImmutableGetPinnedDialogs(Builder builder) {
        this.folderId = builder.folderId;
        this.identifier = builder.identifierIsSet() ? builder.identifier : GetPinnedDialogs.super.identifier();
    }

    private ImmutableGetPinnedDialogs(int identifier, int folderId) {
        this.identifier = identifier;
        this.folderId = folderId;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public int folderId() {
        return this.folderId;
    }

    public final ImmutableGetPinnedDialogs withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableGetPinnedDialogs(value, this.folderId);
    }

    public final ImmutableGetPinnedDialogs withFolderId(int value) {
        if (this.folderId == value) {
            return this;
        }
        return new ImmutableGetPinnedDialogs(this.identifier, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGetPinnedDialogs && this.equalTo(0, (ImmutableGetPinnedDialogs)another);
    }

    private boolean equalTo(int synthetic, ImmutableGetPinnedDialogs another) {
        return this.identifier == another.identifier && this.folderId == another.folderId;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.folderId;
        return h;
    }

    public String toString() {
        return "GetPinnedDialogs{identifier=" + this.identifier + ", folderId=" + this.folderId + "}";
    }

    public static ImmutableGetPinnedDialogs of(int folderId) {
        return new ImmutableGetPinnedDialogs(folderId);
    }

    public static ImmutableGetPinnedDialogs copyOf(GetPinnedDialogs instance) {
        if (instance instanceof ImmutableGetPinnedDialogs) {
            return (ImmutableGetPinnedDialogs)instance;
        }
        return ImmutableGetPinnedDialogs.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_FOLDER_ID = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private int folderId;

        private Builder() {
        }

        public final Builder from(GetPinnedDialogs instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            GetPinnedDialogs instance;
            long bits = 0L;
            if (object instanceof GetPinnedDialogs) {
                instance = (GetPinnedDialogs)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.folderId(instance.folderId());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder folderId(int folderId) {
            this.folderId = folderId;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableGetPinnedDialogs build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableGetPinnedDialogs(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("folderId");
            }
            return "Cannot build GetPinnedDialogs, some of required attributes are not set " + attributes;
        }
    }
}

