/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.messages;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import reactor.util.annotation.Nullable;
import telegram4j.tl.InputPeer;
import telegram4j.tl.api.TlEncodingUtil;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.messages.GetPollVotes;

public final class ImmutableGetPollVotes
implements GetPollVotes {
    private final int identifier;
    private final int flags;
    private final InputPeer peer;
    private final int id;
    private final ByteBuf option;
    @Nullable
    private final String offset;
    private final int limit;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableGetPollVotes(InputPeer peer, int id, int limit) {
        this.peer = Objects.requireNonNull(peer, "peer");
        this.id = id;
        this.limit = limit;
        this.option = null;
        this.offset = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableGetPollVotes(Builder builder) {
        this.peer = builder.peer;
        this.id = builder.id;
        this.option = builder.option_build();
        this.offset = builder.offset;
        this.limit = builder.limit;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableGetPollVotes(int identifier, int flags, InputPeer peer, int id, ByteBuf option, @Nullable String offset, int limit) {
        this.identifier = identifier;
        this.flags = flags;
        this.peer = peer;
        this.id = id;
        this.option = option;
        this.offset = offset;
        this.limit = limit;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return GetPollVotes.super.identifier();
    }

    private int flagsInitialize() {
        return GetPollVotes.super.flags();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public InputPeer peer() {
        return this.peer;
    }

    @Override
    public int id() {
        return this.id;
    }

    @Override
    public Optional<ByteBuf> option() {
        return Optional.ofNullable(this.option).map(ByteBuf::duplicate);
    }

    @Override
    @Nullable
    public String offset() {
        return this.offset;
    }

    @Override
    public int limit() {
        return this.limit;
    }

    public final ImmutableGetPollVotes withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableGetPollVotes(value, this.flags, this.peer, this.id, this.option, this.offset, this.limit);
    }

    public final ImmutableGetPollVotes withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableGetPollVotes(this.identifier, value, this.peer, this.id, this.option, this.offset, this.limit);
    }

    public final ImmutableGetPollVotes withPeer(InputPeer value) {
        if (this.peer == value) {
            return this;
        }
        InputPeer newValue = Objects.requireNonNull(value, "peer");
        return new ImmutableGetPollVotes(this.identifier, this.flags, newValue, this.id, this.option, this.offset, this.limit);
    }

    public final ImmutableGetPollVotes withId(int value) {
        if (this.id == value) {
            return this;
        }
        return new ImmutableGetPollVotes(this.identifier, this.flags, this.peer, value, this.option, this.offset, this.limit);
    }

    public ImmutableGetPollVotes withOption(Optional<ByteBuf> value) {
        ByteBuf newValue = value.map(TlEncodingUtil::copyAsUnpooled).orElse(null);
        if (this.option == newValue) {
            return this;
        }
        return new ImmutableGetPollVotes(this.identifier, this.flags, this.peer, this.id, newValue, this.offset, this.limit);
    }

    public ImmutableGetPollVotes withOption(ByteBuf value) {
        ByteBuf newValue = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
        if (this.option == newValue) {
            return this;
        }
        return new ImmutableGetPollVotes(this.identifier, this.flags, this.peer, this.id, newValue, this.offset, this.limit);
    }

    public final ImmutableGetPollVotes withOffset(@Nullable String value) {
        if (Objects.equals(this.offset, value)) {
            return this;
        }
        return new ImmutableGetPollVotes(this.identifier, this.flags, this.peer, this.id, this.option, value, this.limit);
    }

    public final ImmutableGetPollVotes withLimit(int value) {
        if (this.limit == value) {
            return this;
        }
        return new ImmutableGetPollVotes(this.identifier, this.flags, this.peer, this.id, this.option, this.offset, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGetPollVotes && this.equalTo(0, (ImmutableGetPollVotes)another);
    }

    private boolean equalTo(int synthetic, ImmutableGetPollVotes another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.peer.equals(another.peer) && this.id == another.id && this.option().equals(another.option()) && Objects.equals(this.offset, another.offset) && this.limit == another.limit;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + this.peer.hashCode();
        h += (h << 5) + this.id;
        h += (h << 5) + this.option().hashCode();
        h += (h << 5) + Objects.hashCode(this.offset);
        h += (h << 5) + this.limit;
        return h;
    }

    public String toString() {
        return "GetPollVotes{identifier=" + this.identifier + ", flags=" + this.flags + ", peer=" + this.peer + ", id=" + this.id + ", option=" + this.option().map(ByteBufUtil::hexDump).toString() + ", offset=" + this.offset + ", limit=" + this.limit + "}";
    }

    public static ImmutableGetPollVotes of(InputPeer peer, int id, int limit) {
        return new ImmutableGetPollVotes(peer, id, limit);
    }

    public static ImmutableGetPollVotes copyOf(GetPollVotes instance) {
        if (instance instanceof ImmutableGetPollVotes) {
            return (ImmutableGetPollVotes)instance;
        }
        return ImmutableGetPollVotes.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PEER = 1L;
        private static final long INIT_BIT_ID = 2L;
        private static final long INIT_BIT_LIMIT = 4L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private long initBits = 7L;
        private long optBits;
        private ByteBuf option_value = null;
        private int identifier;
        private int flags;
        private InputPeer peer;
        private int id;
        private String offset;
        private int limit;

        private Builder() {
        }

        public final Builder from(GetPollVotes instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            GetPollVotes instance;
            long bits = 0L;
            if (object instanceof GetPollVotes) {
                String offsetValue;
                instance = (GetPollVotes)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((offsetValue = instance.offset()) != null) {
                    this.offset(offsetValue);
                }
                this.peer(instance.peer());
                this.flags(instance.flags());
                this.limit(instance.limit());
                this.id(instance.id());
                this.option(instance.option());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder peer(InputPeer peer) {
            this.peer = Objects.requireNonNull(peer, "peer");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder id(int id) {
            this.id = id;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public Builder option(@Nullable ByteBuf value) {
            this.option_value = value != null ? TlEncodingUtil.copyAsUnpooled((ByteBuf)value) : null;
            return this;
        }

        public Builder option(Optional<ByteBuf> value) {
            this.option_value = value.map(TlEncodingUtil::copyAsUnpooled).orElse(null);
            return this;
        }

        public final Builder offset(@Nullable String offset) {
            this.offset = offset;
            return this;
        }

        public final Builder limit(int limit) {
            this.limit = limit;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableGetPollVotes build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableGetPollVotes(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("peer");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("limit");
            }
            return "Cannot build GetPollVotes, some of required attributes are not set " + attributes;
        }

        private ByteBuf option_build() {
            return this.option_value;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableGetPollVotes.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableGetPollVotes.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            return "Cannot build GetPollVotes, attribute initializers form cycle " + attributes;
        }
    }
}

