/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.messages;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputPeer;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.messages.GetRecentLocations;

public final class ImmutableGetRecentLocations
implements GetRecentLocations {
    private final int identifier;
    private final InputPeer peer;
    private final int limit;
    private final long hash;

    private ImmutableGetRecentLocations(InputPeer peer, int limit, long hash) {
        this.peer = Objects.requireNonNull(peer, "peer");
        this.limit = limit;
        this.hash = hash;
        this.identifier = GetRecentLocations.super.identifier();
    }

    private ImmutableGetRecentLocations(Builder builder) {
        this.peer = builder.peer;
        this.limit = builder.limit;
        this.hash = builder.hash;
        this.identifier = builder.identifierIsSet() ? builder.identifier : GetRecentLocations.super.identifier();
    }

    private ImmutableGetRecentLocations(int identifier, InputPeer peer, int limit, long hash) {
        this.identifier = identifier;
        this.peer = peer;
        this.limit = limit;
        this.hash = hash;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public InputPeer peer() {
        return this.peer;
    }

    @Override
    public int limit() {
        return this.limit;
    }

    @Override
    public long hash() {
        return this.hash;
    }

    public final ImmutableGetRecentLocations withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableGetRecentLocations(value, this.peer, this.limit, this.hash);
    }

    public final ImmutableGetRecentLocations withPeer(InputPeer value) {
        if (this.peer == value) {
            return this;
        }
        InputPeer newValue = Objects.requireNonNull(value, "peer");
        return new ImmutableGetRecentLocations(this.identifier, newValue, this.limit, this.hash);
    }

    public final ImmutableGetRecentLocations withLimit(int value) {
        if (this.limit == value) {
            return this;
        }
        return new ImmutableGetRecentLocations(this.identifier, this.peer, value, this.hash);
    }

    public final ImmutableGetRecentLocations withHash(long value) {
        if (this.hash == value) {
            return this;
        }
        return new ImmutableGetRecentLocations(this.identifier, this.peer, this.limit, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGetRecentLocations && this.equalTo(0, (ImmutableGetRecentLocations)another);
    }

    private boolean equalTo(int synthetic, ImmutableGetRecentLocations another) {
        return this.identifier == another.identifier && this.peer.equals(another.peer) && this.limit == another.limit && this.hash == another.hash;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.peer.hashCode();
        h += (h << 5) + this.limit;
        h += (h << 5) + Long.hashCode(this.hash);
        return h;
    }

    public String toString() {
        return "GetRecentLocations{identifier=" + this.identifier + ", peer=" + this.peer + ", limit=" + this.limit + ", hash=" + this.hash + "}";
    }

    public static ImmutableGetRecentLocations of(InputPeer peer, int limit, long hash) {
        return new ImmutableGetRecentLocations(peer, limit, hash);
    }

    public static ImmutableGetRecentLocations copyOf(GetRecentLocations instance) {
        if (instance instanceof ImmutableGetRecentLocations) {
            return (ImmutableGetRecentLocations)instance;
        }
        return ImmutableGetRecentLocations.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PEER = 1L;
        private static final long INIT_BIT_LIMIT = 2L;
        private static final long INIT_BIT_HASH = 4L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 7L;
        private long optBits;
        private int identifier;
        private InputPeer peer;
        private int limit;
        private long hash;

        private Builder() {
        }

        public final Builder from(GetRecentLocations instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            GetRecentLocations instance;
            long bits = 0L;
            if (object instanceof GetRecentLocations) {
                instance = (GetRecentLocations)object;
                this.limit(instance.limit());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.peer(instance.peer());
                this.hash(instance.hash());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder peer(InputPeer peer) {
            this.peer = Objects.requireNonNull(peer, "peer");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder limit(int limit) {
            this.limit = limit;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder hash(long hash) {
            this.hash = hash;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableGetRecentLocations build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableGetRecentLocations(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("peer");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("limit");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("hash");
            }
            return "Cannot build GetRecentLocations, some of required attributes are not set " + attributes;
        }
    }
}

