/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.messages;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.messages.GetRecentStickers;

public final class ImmutableGetRecentStickers
implements GetRecentStickers {
    private final int identifier;
    private final int flags;
    private final boolean attached;
    private final long hash;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableGetRecentStickers(long hash) {
        this.hash = hash;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.attached = this.initShim.attached();
        this.initShim = null;
    }

    private ImmutableGetRecentStickers(Builder builder) {
        this.hash = builder.hash;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.attachedIsSet()) {
            this.initShim.attached(builder.attached);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.attached = this.initShim.attached();
        this.initShim = null;
    }

    private ImmutableGetRecentStickers(int identifier, int flags, boolean attached, long hash) {
        this.identifier = identifier;
        this.flags = flags;
        this.attached = attached;
        this.hash = hash;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return GetRecentStickers.super.identifier();
    }

    private int flagsInitialize() {
        return GetRecentStickers.super.flags();
    }

    private boolean attachedInitialize() {
        return GetRecentStickers.super.attached();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean attached() {
        InitShim shim = this.initShim;
        return shim != null ? shim.attached() : this.attached;
    }

    @Override
    public long hash() {
        return this.hash;
    }

    public final ImmutableGetRecentStickers withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableGetRecentStickers(value, this.flags, this.attached, this.hash);
    }

    public final ImmutableGetRecentStickers withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableGetRecentStickers(this.identifier, value, this.attached, this.hash);
    }

    public final ImmutableGetRecentStickers withAttached(boolean value) {
        if (this.attached == value) {
            return this;
        }
        return new ImmutableGetRecentStickers(this.identifier, this.flags, value, this.hash);
    }

    public final ImmutableGetRecentStickers withHash(long value) {
        if (this.hash == value) {
            return this;
        }
        return new ImmutableGetRecentStickers(this.identifier, this.flags, this.attached, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGetRecentStickers && this.equalTo(0, (ImmutableGetRecentStickers)another);
    }

    private boolean equalTo(int synthetic, ImmutableGetRecentStickers another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.attached == another.attached && this.hash == another.hash;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.attached);
        h += (h << 5) + Long.hashCode(this.hash);
        return h;
    }

    public String toString() {
        return "GetRecentStickers{identifier=" + this.identifier + ", flags=" + this.flags + ", attached=" + this.attached + ", hash=" + this.hash + "}";
    }

    public static ImmutableGetRecentStickers of(long hash) {
        return new ImmutableGetRecentStickers(hash);
    }

    public static ImmutableGetRecentStickers copyOf(GetRecentStickers instance) {
        if (instance instanceof ImmutableGetRecentStickers) {
            return (ImmutableGetRecentStickers)instance;
        }
        return ImmutableGetRecentStickers.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_HASH = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_ATTACHED = 4L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean attached;
        private long hash;

        private Builder() {
        }

        public final Builder from(GetRecentStickers instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            GetRecentStickers instance;
            long bits = 0L;
            if (object instanceof GetRecentStickers) {
                instance = (GetRecentStickers)object;
                this.flags(instance.flags());
                this.attached(instance.attached());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.hash(instance.hash());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder attached(boolean attached) {
            this.attached = attached;
            this.optBits |= 4L;
            return this;
        }

        public final Builder hash(long hash) {
            this.hash = hash;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableGetRecentStickers build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableGetRecentStickers(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean attachedIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("hash");
            }
            return "Cannot build GetRecentStickers, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte attachedBuildStage = 0;
        private boolean attached;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableGetRecentStickers.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableGetRecentStickers.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean attached() {
            if (this.attachedBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.attachedBuildStage == 0) {
                this.attachedBuildStage = (byte)-1;
                this.attached = ImmutableGetRecentStickers.this.attachedInitialize();
                this.attachedBuildStage = 1;
            }
            return this.attached;
        }

        void attached(boolean attached) {
            this.attached = attached;
            this.attachedBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.attachedBuildStage == -1) {
                attributes.add("attached");
            }
            return "Cannot build GetRecentStickers, attribute initializers form cycle " + attributes;
        }
    }
}

