/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.messages;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputPeer;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.messages.GetScheduledHistory;

public final class ImmutableGetScheduledHistory
implements GetScheduledHistory {
    private final int identifier;
    private final InputPeer peer;
    private final long hash;

    private ImmutableGetScheduledHistory(InputPeer peer, long hash) {
        this.peer = Objects.requireNonNull(peer, "peer");
        this.hash = hash;
        this.identifier = GetScheduledHistory.super.identifier();
    }

    private ImmutableGetScheduledHistory(Builder builder) {
        this.peer = builder.peer;
        this.hash = builder.hash;
        this.identifier = builder.identifierIsSet() ? builder.identifier : GetScheduledHistory.super.identifier();
    }

    private ImmutableGetScheduledHistory(int identifier, InputPeer peer, long hash) {
        this.identifier = identifier;
        this.peer = peer;
        this.hash = hash;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public InputPeer peer() {
        return this.peer;
    }

    @Override
    public long hash() {
        return this.hash;
    }

    public final ImmutableGetScheduledHistory withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableGetScheduledHistory(value, this.peer, this.hash);
    }

    public final ImmutableGetScheduledHistory withPeer(InputPeer value) {
        if (this.peer == value) {
            return this;
        }
        InputPeer newValue = Objects.requireNonNull(value, "peer");
        return new ImmutableGetScheduledHistory(this.identifier, newValue, this.hash);
    }

    public final ImmutableGetScheduledHistory withHash(long value) {
        if (this.hash == value) {
            return this;
        }
        return new ImmutableGetScheduledHistory(this.identifier, this.peer, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGetScheduledHistory && this.equalTo(0, (ImmutableGetScheduledHistory)another);
    }

    private boolean equalTo(int synthetic, ImmutableGetScheduledHistory another) {
        return this.identifier == another.identifier && this.peer.equals(another.peer) && this.hash == another.hash;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.peer.hashCode();
        h += (h << 5) + Long.hashCode(this.hash);
        return h;
    }

    public String toString() {
        return "GetScheduledHistory{identifier=" + this.identifier + ", peer=" + this.peer + ", hash=" + this.hash + "}";
    }

    public static ImmutableGetScheduledHistory of(InputPeer peer, long hash) {
        return new ImmutableGetScheduledHistory(peer, hash);
    }

    public static ImmutableGetScheduledHistory copyOf(GetScheduledHistory instance) {
        if (instance instanceof ImmutableGetScheduledHistory) {
            return (ImmutableGetScheduledHistory)instance;
        }
        return ImmutableGetScheduledHistory.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PEER = 1L;
        private static final long INIT_BIT_HASH = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private InputPeer peer;
        private long hash;

        private Builder() {
        }

        public final Builder from(GetScheduledHistory instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            GetScheduledHistory instance;
            long bits = 0L;
            if (object instanceof GetScheduledHistory) {
                instance = (GetScheduledHistory)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.peer(instance.peer());
                this.hash(instance.hash());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder peer(InputPeer peer) {
            this.peer = Objects.requireNonNull(peer, "peer");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder hash(long hash) {
            this.hash = hash;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableGetScheduledHistory build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableGetScheduledHistory(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("peer");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("hash");
            }
            return "Cannot build GetScheduledHistory, some of required attributes are not set " + attributes;
        }
    }
}

