/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.messages;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import telegram4j.tl.InputPeer;
import telegram4j.tl.MessagesFilter;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.messages.GetSearchCounters;

public final class ImmutableGetSearchCounters
implements GetSearchCounters {
    private final int identifier;
    private final InputPeer peer;
    private final List<MessagesFilter> filters;

    private ImmutableGetSearchCounters(InputPeer peer) {
        this.peer = Objects.requireNonNull(peer, "peer");
        this.filters = Collections.emptyList();
        this.identifier = GetSearchCounters.super.identifier();
    }

    private ImmutableGetSearchCounters(Builder builder) {
        this.peer = builder.peer;
        this.filters = ImmutableGetSearchCounters.createUnmodifiableList(true, builder.filters);
        this.identifier = builder.identifierIsSet() ? builder.identifier : GetSearchCounters.super.identifier();
    }

    private ImmutableGetSearchCounters(int identifier, InputPeer peer, List<MessagesFilter> filters) {
        this.identifier = identifier;
        this.peer = peer;
        this.filters = filters;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public InputPeer peer() {
        return this.peer;
    }

    @Override
    public List<MessagesFilter> filters() {
        return this.filters;
    }

    public final ImmutableGetSearchCounters withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableGetSearchCounters(value, this.peer, this.filters);
    }

    public final ImmutableGetSearchCounters withPeer(InputPeer value) {
        if (this.peer == value) {
            return this;
        }
        InputPeer newValue = Objects.requireNonNull(value, "peer");
        return new ImmutableGetSearchCounters(this.identifier, newValue, this.filters);
    }

    public final ImmutableGetSearchCounters withFilters(MessagesFilter ... elements) {
        List<MessagesFilter> newValue = ImmutableGetSearchCounters.createUnmodifiableList(false, ImmutableGetSearchCounters.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableGetSearchCounters(this.identifier, this.peer, newValue);
    }

    public final ImmutableGetSearchCounters withFilters(Iterable<? extends MessagesFilter> elements) {
        if (this.filters == elements) {
            return this;
        }
        List<MessagesFilter> newValue = ImmutableGetSearchCounters.createUnmodifiableList(false, ImmutableGetSearchCounters.createSafeList(elements, true, false));
        return new ImmutableGetSearchCounters(this.identifier, this.peer, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGetSearchCounters && this.equalTo(0, (ImmutableGetSearchCounters)another);
    }

    private boolean equalTo(int synthetic, ImmutableGetSearchCounters another) {
        return this.identifier == another.identifier && this.peer.equals(another.peer) && this.filters.equals(another.filters);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.peer.hashCode();
        h += (h << 5) + this.filters.hashCode();
        return h;
    }

    public String toString() {
        return "GetSearchCounters{identifier=" + this.identifier + ", peer=" + this.peer + ", filters=" + this.filters + "}";
    }

    public static ImmutableGetSearchCounters of(InputPeer peer) {
        return new ImmutableGetSearchCounters(peer);
    }

    public static ImmutableGetSearchCounters copyOf(GetSearchCounters instance) {
        if (instance instanceof ImmutableGetSearchCounters) {
            return (ImmutableGetSearchCounters)instance;
        }
        return ImmutableGetSearchCounters.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_PEER = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private InputPeer peer;
        private List<MessagesFilter> filters = new ArrayList<MessagesFilter>();

        private Builder() {
        }

        public final Builder from(GetSearchCounters instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            GetSearchCounters instance;
            long bits = 0L;
            if (object instanceof GetSearchCounters) {
                instance = (GetSearchCounters)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.peer(instance.peer());
                this.addAllFilters(instance.filters());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder peer(InputPeer peer) {
            this.peer = Objects.requireNonNull(peer, "peer");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder addFilter(MessagesFilter element) {
            this.filters.add(Objects.requireNonNull(element, "filters element"));
            return this;
        }

        public final Builder addFilters(MessagesFilter ... elements) {
            for (MessagesFilter element : elements) {
                this.filters.add(Objects.requireNonNull(element, "filters element"));
            }
            return this;
        }

        public final Builder filters(Iterable<? extends MessagesFilter> elements) {
            this.filters.clear();
            return this.addAllFilters(elements);
        }

        public final Builder addAllFilters(Iterable<? extends MessagesFilter> elements) {
            for (MessagesFilter messagesFilter : elements) {
                this.filters.add(Objects.requireNonNull(messagesFilter, "filters element"));
            }
            return this;
        }

        public ImmutableGetSearchCounters build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableGetSearchCounters(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("peer");
            }
            return "Cannot build GetSearchCounters, some of required attributes are not set " + attributes;
        }
    }
}

