/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.messages;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputPeer;
import telegram4j.tl.MessagesFilter;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.messages.GetSearchResultsCalendar;

public final class ImmutableGetSearchResultsCalendar
implements GetSearchResultsCalendar {
    private final int identifier;
    private final InputPeer peer;
    private final MessagesFilter filter;
    private final int offsetId;
    private final int offsetDate;

    private ImmutableGetSearchResultsCalendar(InputPeer peer, MessagesFilter filter, int offsetId, int offsetDate) {
        this.peer = Objects.requireNonNull(peer, "peer");
        this.filter = Objects.requireNonNull(filter, "filter");
        this.offsetId = offsetId;
        this.offsetDate = offsetDate;
        this.identifier = GetSearchResultsCalendar.super.identifier();
    }

    private ImmutableGetSearchResultsCalendar(Builder builder) {
        this.peer = builder.peer;
        this.filter = builder.filter;
        this.offsetId = builder.offsetId;
        this.offsetDate = builder.offsetDate;
        this.identifier = builder.identifierIsSet() ? builder.identifier : GetSearchResultsCalendar.super.identifier();
    }

    private ImmutableGetSearchResultsCalendar(int identifier, InputPeer peer, MessagesFilter filter, int offsetId, int offsetDate) {
        this.identifier = identifier;
        this.peer = peer;
        this.filter = filter;
        this.offsetId = offsetId;
        this.offsetDate = offsetDate;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public InputPeer peer() {
        return this.peer;
    }

    @Override
    public MessagesFilter filter() {
        return this.filter;
    }

    @Override
    public int offsetId() {
        return this.offsetId;
    }

    @Override
    public int offsetDate() {
        return this.offsetDate;
    }

    public final ImmutableGetSearchResultsCalendar withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableGetSearchResultsCalendar(value, this.peer, this.filter, this.offsetId, this.offsetDate);
    }

    public final ImmutableGetSearchResultsCalendar withPeer(InputPeer value) {
        if (this.peer == value) {
            return this;
        }
        InputPeer newValue = Objects.requireNonNull(value, "peer");
        return new ImmutableGetSearchResultsCalendar(this.identifier, newValue, this.filter, this.offsetId, this.offsetDate);
    }

    public final ImmutableGetSearchResultsCalendar withFilter(MessagesFilter value) {
        if (this.filter == value) {
            return this;
        }
        MessagesFilter newValue = Objects.requireNonNull(value, "filter");
        return new ImmutableGetSearchResultsCalendar(this.identifier, this.peer, newValue, this.offsetId, this.offsetDate);
    }

    public final ImmutableGetSearchResultsCalendar withOffsetId(int value) {
        if (this.offsetId == value) {
            return this;
        }
        return new ImmutableGetSearchResultsCalendar(this.identifier, this.peer, this.filter, value, this.offsetDate);
    }

    public final ImmutableGetSearchResultsCalendar withOffsetDate(int value) {
        if (this.offsetDate == value) {
            return this;
        }
        return new ImmutableGetSearchResultsCalendar(this.identifier, this.peer, this.filter, this.offsetId, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGetSearchResultsCalendar && this.equalTo(0, (ImmutableGetSearchResultsCalendar)another);
    }

    private boolean equalTo(int synthetic, ImmutableGetSearchResultsCalendar another) {
        return this.identifier == another.identifier && this.peer.equals(another.peer) && this.filter.equals(another.filter) && this.offsetId == another.offsetId && this.offsetDate == another.offsetDate;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.peer.hashCode();
        h += (h << 5) + this.filter.hashCode();
        h += (h << 5) + this.offsetId;
        h += (h << 5) + this.offsetDate;
        return h;
    }

    public String toString() {
        return "GetSearchResultsCalendar{identifier=" + this.identifier + ", peer=" + this.peer + ", filter=" + this.filter + ", offsetId=" + this.offsetId + ", offsetDate=" + this.offsetDate + "}";
    }

    public static ImmutableGetSearchResultsCalendar of(InputPeer peer, MessagesFilter filter, int offsetId, int offsetDate) {
        return new ImmutableGetSearchResultsCalendar(peer, filter, offsetId, offsetDate);
    }

    public static ImmutableGetSearchResultsCalendar copyOf(GetSearchResultsCalendar instance) {
        if (instance instanceof ImmutableGetSearchResultsCalendar) {
            return (ImmutableGetSearchResultsCalendar)instance;
        }
        return ImmutableGetSearchResultsCalendar.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PEER = 1L;
        private static final long INIT_BIT_FILTER = 2L;
        private static final long INIT_BIT_OFFSET_ID = 4L;
        private static final long INIT_BIT_OFFSET_DATE = 8L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 15L;
        private long optBits;
        private int identifier;
        private InputPeer peer;
        private MessagesFilter filter;
        private int offsetId;
        private int offsetDate;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(GetSearchResultsCalendar instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof GetSearchResultsCalendar) {
                instance = (GetSearchResultsCalendar)object;
                this.filter(instance.filter());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.offsetDate(instance.offsetDate());
                this.peer(instance.peer());
                this.offsetId(instance.offsetId());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder peer(InputPeer peer) {
            this.peer = Objects.requireNonNull(peer, "peer");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder filter(MessagesFilter filter) {
            this.filter = Objects.requireNonNull(filter, "filter");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder offsetId(int offsetId) {
            this.offsetId = offsetId;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder offsetDate(int offsetDate) {
            this.offsetDate = offsetDate;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public ImmutableGetSearchResultsCalendar build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableGetSearchResultsCalendar(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("peer");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("filter");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("offsetId");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("offsetDate");
            }
            return "Cannot build GetSearchResultsCalendar, some of required attributes are not set " + attributes;
        }
    }
}

