/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.messages;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputPeer;
import telegram4j.tl.MessagesFilter;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.messages.GetSearchResultsPositions;

public final class ImmutableGetSearchResultsPositions
implements GetSearchResultsPositions {
    private final int identifier;
    private final InputPeer peer;
    private final MessagesFilter filter;
    private final int offsetId;
    private final int limit;

    private ImmutableGetSearchResultsPositions(InputPeer peer, MessagesFilter filter, int offsetId, int limit) {
        this.peer = Objects.requireNonNull(peer, "peer");
        this.filter = Objects.requireNonNull(filter, "filter");
        this.offsetId = offsetId;
        this.limit = limit;
        this.identifier = GetSearchResultsPositions.super.identifier();
    }

    private ImmutableGetSearchResultsPositions(Builder builder) {
        this.peer = builder.peer;
        this.filter = builder.filter;
        this.offsetId = builder.offsetId;
        this.limit = builder.limit;
        this.identifier = builder.identifierIsSet() ? builder.identifier : GetSearchResultsPositions.super.identifier();
    }

    private ImmutableGetSearchResultsPositions(int identifier, InputPeer peer, MessagesFilter filter, int offsetId, int limit) {
        this.identifier = identifier;
        this.peer = peer;
        this.filter = filter;
        this.offsetId = offsetId;
        this.limit = limit;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public InputPeer peer() {
        return this.peer;
    }

    @Override
    public MessagesFilter filter() {
        return this.filter;
    }

    @Override
    public int offsetId() {
        return this.offsetId;
    }

    @Override
    public int limit() {
        return this.limit;
    }

    public final ImmutableGetSearchResultsPositions withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableGetSearchResultsPositions(value, this.peer, this.filter, this.offsetId, this.limit);
    }

    public final ImmutableGetSearchResultsPositions withPeer(InputPeer value) {
        if (this.peer == value) {
            return this;
        }
        InputPeer newValue = Objects.requireNonNull(value, "peer");
        return new ImmutableGetSearchResultsPositions(this.identifier, newValue, this.filter, this.offsetId, this.limit);
    }

    public final ImmutableGetSearchResultsPositions withFilter(MessagesFilter value) {
        if (this.filter == value) {
            return this;
        }
        MessagesFilter newValue = Objects.requireNonNull(value, "filter");
        return new ImmutableGetSearchResultsPositions(this.identifier, this.peer, newValue, this.offsetId, this.limit);
    }

    public final ImmutableGetSearchResultsPositions withOffsetId(int value) {
        if (this.offsetId == value) {
            return this;
        }
        return new ImmutableGetSearchResultsPositions(this.identifier, this.peer, this.filter, value, this.limit);
    }

    public final ImmutableGetSearchResultsPositions withLimit(int value) {
        if (this.limit == value) {
            return this;
        }
        return new ImmutableGetSearchResultsPositions(this.identifier, this.peer, this.filter, this.offsetId, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGetSearchResultsPositions && this.equalTo(0, (ImmutableGetSearchResultsPositions)another);
    }

    private boolean equalTo(int synthetic, ImmutableGetSearchResultsPositions another) {
        return this.identifier == another.identifier && this.peer.equals(another.peer) && this.filter.equals(another.filter) && this.offsetId == another.offsetId && this.limit == another.limit;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.peer.hashCode();
        h += (h << 5) + this.filter.hashCode();
        h += (h << 5) + this.offsetId;
        h += (h << 5) + this.limit;
        return h;
    }

    public String toString() {
        return "GetSearchResultsPositions{identifier=" + this.identifier + ", peer=" + this.peer + ", filter=" + this.filter + ", offsetId=" + this.offsetId + ", limit=" + this.limit + "}";
    }

    public static ImmutableGetSearchResultsPositions of(InputPeer peer, MessagesFilter filter, int offsetId, int limit) {
        return new ImmutableGetSearchResultsPositions(peer, filter, offsetId, limit);
    }

    public static ImmutableGetSearchResultsPositions copyOf(GetSearchResultsPositions instance) {
        if (instance instanceof ImmutableGetSearchResultsPositions) {
            return (ImmutableGetSearchResultsPositions)instance;
        }
        return ImmutableGetSearchResultsPositions.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PEER = 1L;
        private static final long INIT_BIT_FILTER = 2L;
        private static final long INIT_BIT_OFFSET_ID = 4L;
        private static final long INIT_BIT_LIMIT = 8L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 15L;
        private long optBits;
        private int identifier;
        private InputPeer peer;
        private MessagesFilter filter;
        private int offsetId;
        private int limit;

        private Builder() {
        }

        public final Builder from(GetSearchResultsPositions instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            GetSearchResultsPositions instance;
            long bits = 0L;
            if (object instanceof GetSearchResultsPositions) {
                instance = (GetSearchResultsPositions)object;
                this.filter(instance.filter());
                this.limit(instance.limit());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.peer(instance.peer());
                this.offsetId(instance.offsetId());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder peer(InputPeer peer) {
            this.peer = Objects.requireNonNull(peer, "peer");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder filter(MessagesFilter filter) {
            this.filter = Objects.requireNonNull(filter, "filter");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder offsetId(int offsetId) {
            this.offsetId = offsetId;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder limit(int limit) {
            this.limit = limit;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public ImmutableGetSearchResultsPositions build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableGetSearchResultsPositions(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("peer");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("filter");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("offsetId");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("limit");
            }
            return "Cannot build GetSearchResultsPositions, some of required attributes are not set " + attributes;
        }
    }
}

