/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.messages;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputStickerSet;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.messages.GetStickerSet;

public final class ImmutableGetStickerSet
implements GetStickerSet {
    private final int identifier;
    private final InputStickerSet stickerset;
    private final int hash;

    private ImmutableGetStickerSet(InputStickerSet stickerset, int hash) {
        this.stickerset = Objects.requireNonNull(stickerset, "stickerset");
        this.hash = hash;
        this.identifier = GetStickerSet.super.identifier();
    }

    private ImmutableGetStickerSet(Builder builder) {
        this.stickerset = builder.stickerset;
        this.hash = builder.hash;
        this.identifier = builder.identifierIsSet() ? builder.identifier : GetStickerSet.super.identifier();
    }

    private ImmutableGetStickerSet(int identifier, InputStickerSet stickerset, int hash) {
        this.identifier = identifier;
        this.stickerset = stickerset;
        this.hash = hash;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public InputStickerSet stickerset() {
        return this.stickerset;
    }

    @Override
    public int hash() {
        return this.hash;
    }

    public final ImmutableGetStickerSet withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableGetStickerSet(value, this.stickerset, this.hash);
    }

    public final ImmutableGetStickerSet withStickerset(InputStickerSet value) {
        if (this.stickerset == value) {
            return this;
        }
        InputStickerSet newValue = Objects.requireNonNull(value, "stickerset");
        return new ImmutableGetStickerSet(this.identifier, newValue, this.hash);
    }

    public final ImmutableGetStickerSet withHash(int value) {
        if (this.hash == value) {
            return this;
        }
        return new ImmutableGetStickerSet(this.identifier, this.stickerset, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGetStickerSet && this.equalTo(0, (ImmutableGetStickerSet)another);
    }

    private boolean equalTo(int synthetic, ImmutableGetStickerSet another) {
        return this.identifier == another.identifier && this.stickerset.equals(another.stickerset) && this.hash == another.hash;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.stickerset.hashCode();
        h += (h << 5) + this.hash;
        return h;
    }

    public String toString() {
        return "GetStickerSet{identifier=" + this.identifier + ", stickerset=" + this.stickerset + ", hash=" + this.hash + "}";
    }

    public static ImmutableGetStickerSet of(InputStickerSet stickerset, int hash) {
        return new ImmutableGetStickerSet(stickerset, hash);
    }

    public static ImmutableGetStickerSet copyOf(GetStickerSet instance) {
        if (instance instanceof ImmutableGetStickerSet) {
            return (ImmutableGetStickerSet)instance;
        }
        return ImmutableGetStickerSet.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_STICKERSET = 1L;
        private static final long INIT_BIT_HASH = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private InputStickerSet stickerset;
        private int hash;

        private Builder() {
        }

        public final Builder from(GetStickerSet instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            GetStickerSet instance;
            long bits = 0L;
            if (object instanceof GetStickerSet) {
                instance = (GetStickerSet)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.stickerset(instance.stickerset());
                this.hash(instance.hash());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder stickerset(InputStickerSet stickerset) {
            this.stickerset = Objects.requireNonNull(stickerset, "stickerset");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder hash(int hash) {
            this.hash = hash;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableGetStickerSet build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableGetStickerSet(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("stickerset");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("hash");
            }
            return "Cannot build GetStickerSet, some of required attributes are not set " + attributes;
        }
    }
}

