/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.messages;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.messages.GetStickers;

public final class ImmutableGetStickers
implements GetStickers {
    private final int identifier;
    private final String emoticon;
    private final long hash;

    private ImmutableGetStickers(String emoticon, long hash) {
        this.emoticon = Objects.requireNonNull(emoticon, "emoticon");
        this.hash = hash;
        this.identifier = GetStickers.super.identifier();
    }

    private ImmutableGetStickers(Builder builder) {
        this.emoticon = builder.emoticon;
        this.hash = builder.hash;
        this.identifier = builder.identifierIsSet() ? builder.identifier : GetStickers.super.identifier();
    }

    private ImmutableGetStickers(int identifier, String emoticon, long hash) {
        this.identifier = identifier;
        this.emoticon = emoticon;
        this.hash = hash;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public String emoticon() {
        return this.emoticon;
    }

    @Override
    public long hash() {
        return this.hash;
    }

    public final ImmutableGetStickers withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableGetStickers(value, this.emoticon, this.hash);
    }

    public final ImmutableGetStickers withEmoticon(String value) {
        String newValue = Objects.requireNonNull(value, "emoticon");
        if (this.emoticon.equals(newValue)) {
            return this;
        }
        return new ImmutableGetStickers(this.identifier, newValue, this.hash);
    }

    public final ImmutableGetStickers withHash(long value) {
        if (this.hash == value) {
            return this;
        }
        return new ImmutableGetStickers(this.identifier, this.emoticon, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGetStickers && this.equalTo(0, (ImmutableGetStickers)another);
    }

    private boolean equalTo(int synthetic, ImmutableGetStickers another) {
        return this.identifier == another.identifier && this.emoticon.equals(another.emoticon) && this.hash == another.hash;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.emoticon.hashCode();
        h += (h << 5) + Long.hashCode(this.hash);
        return h;
    }

    public String toString() {
        return "GetStickers{identifier=" + this.identifier + ", emoticon=" + this.emoticon + ", hash=" + this.hash + "}";
    }

    public static ImmutableGetStickers of(String emoticon, long hash) {
        return new ImmutableGetStickers(emoticon, hash);
    }

    public static ImmutableGetStickers copyOf(GetStickers instance) {
        if (instance instanceof ImmutableGetStickers) {
            return (ImmutableGetStickers)instance;
        }
        return ImmutableGetStickers.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_EMOTICON = 1L;
        private static final long INIT_BIT_HASH = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private String emoticon;
        private long hash;

        private Builder() {
        }

        public final Builder from(GetStickers instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            GetStickers instance;
            long bits = 0L;
            if (object instanceof GetStickers) {
                instance = (GetStickers)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.emoticon(instance.emoticon());
                this.hash(instance.hash());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder emoticon(String emoticon) {
            this.emoticon = Objects.requireNonNull(emoticon, "emoticon");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder hash(long hash) {
            this.hash = hash;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableGetStickers build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableGetStickers(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("emoticon");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("hash");
            }
            return "Cannot build GetStickers, some of required attributes are not set " + attributes;
        }
    }
}

