/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.messages;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputPeer;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.messages.GetUnreadMentions;

public final class ImmutableGetUnreadMentions
implements GetUnreadMentions {
    private final int identifier;
    private final InputPeer peer;
    private final int offsetId;
    private final int addOffset;
    private final int limit;
    private final int maxId;
    private final int minId;

    private ImmutableGetUnreadMentions(InputPeer peer, int offsetId, int addOffset, int limit, int maxId, int minId) {
        this.peer = Objects.requireNonNull(peer, "peer");
        this.offsetId = offsetId;
        this.addOffset = addOffset;
        this.limit = limit;
        this.maxId = maxId;
        this.minId = minId;
        this.identifier = GetUnreadMentions.super.identifier();
    }

    private ImmutableGetUnreadMentions(Builder builder) {
        this.peer = builder.peer;
        this.offsetId = builder.offsetId;
        this.addOffset = builder.addOffset;
        this.limit = builder.limit;
        this.maxId = builder.maxId;
        this.minId = builder.minId;
        this.identifier = builder.identifierIsSet() ? builder.identifier : GetUnreadMentions.super.identifier();
    }

    private ImmutableGetUnreadMentions(int identifier, InputPeer peer, int offsetId, int addOffset, int limit, int maxId, int minId) {
        this.identifier = identifier;
        this.peer = peer;
        this.offsetId = offsetId;
        this.addOffset = addOffset;
        this.limit = limit;
        this.maxId = maxId;
        this.minId = minId;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public InputPeer peer() {
        return this.peer;
    }

    @Override
    public int offsetId() {
        return this.offsetId;
    }

    @Override
    public int addOffset() {
        return this.addOffset;
    }

    @Override
    public int limit() {
        return this.limit;
    }

    @Override
    public int maxId() {
        return this.maxId;
    }

    @Override
    public int minId() {
        return this.minId;
    }

    public final ImmutableGetUnreadMentions withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableGetUnreadMentions(value, this.peer, this.offsetId, this.addOffset, this.limit, this.maxId, this.minId);
    }

    public final ImmutableGetUnreadMentions withPeer(InputPeer value) {
        if (this.peer == value) {
            return this;
        }
        InputPeer newValue = Objects.requireNonNull(value, "peer");
        return new ImmutableGetUnreadMentions(this.identifier, newValue, this.offsetId, this.addOffset, this.limit, this.maxId, this.minId);
    }

    public final ImmutableGetUnreadMentions withOffsetId(int value) {
        if (this.offsetId == value) {
            return this;
        }
        return new ImmutableGetUnreadMentions(this.identifier, this.peer, value, this.addOffset, this.limit, this.maxId, this.minId);
    }

    public final ImmutableGetUnreadMentions withAddOffset(int value) {
        if (this.addOffset == value) {
            return this;
        }
        return new ImmutableGetUnreadMentions(this.identifier, this.peer, this.offsetId, value, this.limit, this.maxId, this.minId);
    }

    public final ImmutableGetUnreadMentions withLimit(int value) {
        if (this.limit == value) {
            return this;
        }
        return new ImmutableGetUnreadMentions(this.identifier, this.peer, this.offsetId, this.addOffset, value, this.maxId, this.minId);
    }

    public final ImmutableGetUnreadMentions withMaxId(int value) {
        if (this.maxId == value) {
            return this;
        }
        return new ImmutableGetUnreadMentions(this.identifier, this.peer, this.offsetId, this.addOffset, this.limit, value, this.minId);
    }

    public final ImmutableGetUnreadMentions withMinId(int value) {
        if (this.minId == value) {
            return this;
        }
        return new ImmutableGetUnreadMentions(this.identifier, this.peer, this.offsetId, this.addOffset, this.limit, this.maxId, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGetUnreadMentions && this.equalTo(0, (ImmutableGetUnreadMentions)another);
    }

    private boolean equalTo(int synthetic, ImmutableGetUnreadMentions another) {
        return this.identifier == another.identifier && this.peer.equals(another.peer) && this.offsetId == another.offsetId && this.addOffset == another.addOffset && this.limit == another.limit && this.maxId == another.maxId && this.minId == another.minId;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.peer.hashCode();
        h += (h << 5) + this.offsetId;
        h += (h << 5) + this.addOffset;
        h += (h << 5) + this.limit;
        h += (h << 5) + this.maxId;
        h += (h << 5) + this.minId;
        return h;
    }

    public String toString() {
        return "GetUnreadMentions{identifier=" + this.identifier + ", peer=" + this.peer + ", offsetId=" + this.offsetId + ", addOffset=" + this.addOffset + ", limit=" + this.limit + ", maxId=" + this.maxId + ", minId=" + this.minId + "}";
    }

    public static ImmutableGetUnreadMentions of(InputPeer peer, int offsetId, int addOffset, int limit, int maxId, int minId) {
        return new ImmutableGetUnreadMentions(peer, offsetId, addOffset, limit, maxId, minId);
    }

    public static ImmutableGetUnreadMentions copyOf(GetUnreadMentions instance) {
        if (instance instanceof ImmutableGetUnreadMentions) {
            return (ImmutableGetUnreadMentions)instance;
        }
        return ImmutableGetUnreadMentions.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PEER = 1L;
        private static final long INIT_BIT_OFFSET_ID = 2L;
        private static final long INIT_BIT_ADD_OFFSET = 4L;
        private static final long INIT_BIT_LIMIT = 8L;
        private static final long INIT_BIT_MAX_ID = 16L;
        private static final long INIT_BIT_MIN_ID = 32L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 63L;
        private long optBits;
        private int identifier;
        private InputPeer peer;
        private int offsetId;
        private int addOffset;
        private int limit;
        private int maxId;
        private int minId;

        private Builder() {
        }

        public final Builder from(GetUnreadMentions instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            GetUnreadMentions instance;
            long bits = 0L;
            if (object instanceof GetUnreadMentions) {
                instance = (GetUnreadMentions)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.maxId(instance.maxId());
                this.peer(instance.peer());
                this.limit(instance.limit());
                this.addOffset(instance.addOffset());
                this.minId(instance.minId());
                this.offsetId(instance.offsetId());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder peer(InputPeer peer) {
            this.peer = Objects.requireNonNull(peer, "peer");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder offsetId(int offsetId) {
            this.offsetId = offsetId;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder addOffset(int addOffset) {
            this.addOffset = addOffset;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder limit(int limit) {
            this.limit = limit;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder maxId(int maxId) {
            this.maxId = maxId;
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public final Builder minId(int minId) {
            this.minId = minId;
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        public ImmutableGetUnreadMentions build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableGetUnreadMentions(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("peer");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("offsetId");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("addOffset");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("limit");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("maxId");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("minId");
            }
            return "Cannot build GetUnreadMentions, some of required attributes are not set " + attributes;
        }
    }
}

