/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.messages;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.messages.GetWebPage;

public final class ImmutableGetWebPage
implements GetWebPage {
    private final int identifier;
    private final String url;
    private final int hash;

    private ImmutableGetWebPage(String url, int hash) {
        this.url = Objects.requireNonNull(url, "url");
        this.hash = hash;
        this.identifier = GetWebPage.super.identifier();
    }

    private ImmutableGetWebPage(Builder builder) {
        this.url = builder.url;
        this.hash = builder.hash;
        this.identifier = builder.identifierIsSet() ? builder.identifier : GetWebPage.super.identifier();
    }

    private ImmutableGetWebPage(int identifier, String url, int hash) {
        this.identifier = identifier;
        this.url = url;
        this.hash = hash;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public String url() {
        return this.url;
    }

    @Override
    public int hash() {
        return this.hash;
    }

    public final ImmutableGetWebPage withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableGetWebPage(value, this.url, this.hash);
    }

    public final ImmutableGetWebPage withUrl(String value) {
        String newValue = Objects.requireNonNull(value, "url");
        if (this.url.equals(newValue)) {
            return this;
        }
        return new ImmutableGetWebPage(this.identifier, newValue, this.hash);
    }

    public final ImmutableGetWebPage withHash(int value) {
        if (this.hash == value) {
            return this;
        }
        return new ImmutableGetWebPage(this.identifier, this.url, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGetWebPage && this.equalTo(0, (ImmutableGetWebPage)another);
    }

    private boolean equalTo(int synthetic, ImmutableGetWebPage another) {
        return this.identifier == another.identifier && this.url.equals(another.url) && this.hash == another.hash;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.url.hashCode();
        h += (h << 5) + this.hash;
        return h;
    }

    public String toString() {
        return "GetWebPage{identifier=" + this.identifier + ", url=" + this.url + ", hash=" + this.hash + "}";
    }

    public static ImmutableGetWebPage of(String url, int hash) {
        return new ImmutableGetWebPage(url, hash);
    }

    public static ImmutableGetWebPage copyOf(GetWebPage instance) {
        if (instance instanceof ImmutableGetWebPage) {
            return (ImmutableGetWebPage)instance;
        }
        return ImmutableGetWebPage.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_URL = 1L;
        private static final long INIT_BIT_HASH = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private String url;
        private int hash;

        private Builder() {
        }

        public final Builder from(GetWebPage instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            GetWebPage instance;
            long bits = 0L;
            if (object instanceof GetWebPage) {
                instance = (GetWebPage)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.url(instance.url());
                this.hash(instance.hash());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder url(String url) {
            this.url = Objects.requireNonNull(url, "url");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder hash(int hash) {
            this.hash = hash;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableGetWebPage build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableGetWebPage(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("url");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("hash");
            }
            return "Cannot build GetWebPage, some of required attributes are not set " + attributes;
        }
    }
}

