/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.messages;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.MessageEntity;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.messages.GetWebPagePreview;

public final class ImmutableGetWebPagePreview
implements GetWebPagePreview {
    private final int identifier;
    private final int flags;
    private final String message;
    @Nullable
    private final List<MessageEntity> entities;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableGetWebPagePreview(String message) {
        this.message = Objects.requireNonNull(message, "message");
        this.entities = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableGetWebPagePreview(Builder builder) {
        this.message = builder.message;
        List<MessageEntity> list = this.entities = builder.entities == null ? null : ImmutableGetWebPagePreview.createUnmodifiableList(true, builder.entities);
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableGetWebPagePreview(int identifier, int flags, String message, @Nullable List<MessageEntity> entities) {
        this.identifier = identifier;
        this.flags = flags;
        this.message = message;
        this.entities = entities;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return GetWebPagePreview.super.identifier();
    }

    private int flagsInitialize() {
        return GetWebPagePreview.super.flags();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public String message() {
        return this.message;
    }

    @Override
    @Nullable
    public List<MessageEntity> entities() {
        return this.entities;
    }

    public final ImmutableGetWebPagePreview withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableGetWebPagePreview(value, this.flags, this.message, this.entities);
    }

    public final ImmutableGetWebPagePreview withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableGetWebPagePreview(this.identifier, value, this.message, this.entities);
    }

    public final ImmutableGetWebPagePreview withMessage(String value) {
        String newValue = Objects.requireNonNull(value, "message");
        if (this.message.equals(newValue)) {
            return this;
        }
        return new ImmutableGetWebPagePreview(this.identifier, this.flags, newValue, this.entities);
    }

    public final ImmutableGetWebPagePreview withEntities(MessageEntity ... elements) {
        if (elements == null) {
            return new ImmutableGetWebPagePreview(this.identifier, this.flags, this.message, null);
        }
        List<MessageEntity> newValue = Arrays.asList(elements) == null ? null : ImmutableGetWebPagePreview.createUnmodifiableList(false, ImmutableGetWebPagePreview.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableGetWebPagePreview(this.identifier, this.flags, this.message, newValue);
    }

    public final ImmutableGetWebPagePreview withEntities(@Nullable Iterable<? extends MessageEntity> elements) {
        if (this.entities == elements) {
            return this;
        }
        List<MessageEntity> newValue = elements == null ? null : ImmutableGetWebPagePreview.createUnmodifiableList(false, ImmutableGetWebPagePreview.createSafeList(elements, true, false));
        return new ImmutableGetWebPagePreview(this.identifier, this.flags, this.message, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGetWebPagePreview && this.equalTo(0, (ImmutableGetWebPagePreview)another);
    }

    private boolean equalTo(int synthetic, ImmutableGetWebPagePreview another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.message.equals(another.message) && Objects.equals(this.entities, another.entities);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + this.message.hashCode();
        h += (h << 5) + Objects.hashCode(this.entities);
        return h;
    }

    public String toString() {
        return "GetWebPagePreview{identifier=" + this.identifier + ", flags=" + this.flags + ", message=" + this.message + ", entities=" + this.entities + "}";
    }

    public static ImmutableGetWebPagePreview of(String message) {
        return new ImmutableGetWebPagePreview(message);
    }

    public static ImmutableGetWebPagePreview copyOf(GetWebPagePreview instance) {
        if (instance instanceof ImmutableGetWebPagePreview) {
            return (ImmutableGetWebPagePreview)instance;
        }
        return ImmutableGetWebPagePreview.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_MESSAGE = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private int flags;
        private String message;
        private List<MessageEntity> entities = null;

        private Builder() {
        }

        public final Builder from(GetWebPagePreview instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            GetWebPagePreview instance;
            long bits = 0L;
            if (object instanceof GetWebPagePreview) {
                instance = (GetWebPagePreview)object;
                this.flags(instance.flags());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.message(instance.message());
                List<MessageEntity> entitiesValue = instance.entities();
                if (entitiesValue != null) {
                    this.addAllEntities(entitiesValue);
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder message(String message) {
            this.message = Objects.requireNonNull(message, "message");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder addEntity(MessageEntity element) {
            if (this.entities == null) {
                this.entities = new ArrayList<MessageEntity>();
            }
            this.entities.add(Objects.requireNonNull(element, "entities element"));
            return this;
        }

        public final Builder addEntities(MessageEntity ... elements) {
            if (this.entities == null) {
                this.entities = new ArrayList<MessageEntity>();
            }
            for (MessageEntity element : elements) {
                this.entities.add(Objects.requireNonNull(element, "entities element"));
            }
            return this;
        }

        public final Builder entities(@Nullable Iterable<? extends MessageEntity> elements) {
            if (elements == null) {
                this.entities = null;
                return this;
            }
            this.entities = new ArrayList<MessageEntity>();
            return this.addAllEntities(elements);
        }

        public final Builder addAllEntities(Iterable<? extends MessageEntity> elements) {
            Objects.requireNonNull(elements, "entities element");
            if (this.entities == null) {
                this.entities = new ArrayList<MessageEntity>();
            }
            for (MessageEntity messageEntity : elements) {
                this.entities.add(Objects.requireNonNull(messageEntity, "entities element"));
            }
            return this;
        }

        public ImmutableGetWebPagePreview build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableGetWebPagePreview(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("message");
            }
            return "Cannot build GetWebPagePreview, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableGetWebPagePreview.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableGetWebPagePreview.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            return "Cannot build GetWebPagePreview, attribute initializers form cycle " + attributes;
        }
    }
}

