/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.messages;

import java.util.ArrayList;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.InputPeer;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.messages.HideAllChatJoinRequests;

public final class ImmutableHideAllChatJoinRequests
implements HideAllChatJoinRequests {
    private final int identifier;
    private final int flags;
    private final boolean approved;
    private final InputPeer peer;
    @Nullable
    private final String link;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableHideAllChatJoinRequests(InputPeer peer) {
        this.peer = Objects.requireNonNull(peer, "peer");
        this.link = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.approved = this.initShim.approved();
        this.initShim = null;
    }

    private ImmutableHideAllChatJoinRequests(Builder builder) {
        this.peer = builder.peer;
        this.link = builder.link;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.approvedIsSet()) {
            this.initShim.approved(builder.approved);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.approved = this.initShim.approved();
        this.initShim = null;
    }

    private ImmutableHideAllChatJoinRequests(int identifier, int flags, boolean approved, InputPeer peer, @Nullable String link) {
        this.identifier = identifier;
        this.flags = flags;
        this.approved = approved;
        this.peer = peer;
        this.link = link;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return HideAllChatJoinRequests.super.identifier();
    }

    private int flagsInitialize() {
        return HideAllChatJoinRequests.super.flags();
    }

    private boolean approvedInitialize() {
        return HideAllChatJoinRequests.super.approved();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean approved() {
        InitShim shim = this.initShim;
        return shim != null ? shim.approved() : this.approved;
    }

    @Override
    public InputPeer peer() {
        return this.peer;
    }

    @Override
    @Nullable
    public String link() {
        return this.link;
    }

    public final ImmutableHideAllChatJoinRequests withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableHideAllChatJoinRequests(value, this.flags, this.approved, this.peer, this.link);
    }

    public final ImmutableHideAllChatJoinRequests withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableHideAllChatJoinRequests(this.identifier, value, this.approved, this.peer, this.link);
    }

    public final ImmutableHideAllChatJoinRequests withApproved(boolean value) {
        if (this.approved == value) {
            return this;
        }
        return new ImmutableHideAllChatJoinRequests(this.identifier, this.flags, value, this.peer, this.link);
    }

    public final ImmutableHideAllChatJoinRequests withPeer(InputPeer value) {
        if (this.peer == value) {
            return this;
        }
        InputPeer newValue = Objects.requireNonNull(value, "peer");
        return new ImmutableHideAllChatJoinRequests(this.identifier, this.flags, this.approved, newValue, this.link);
    }

    public final ImmutableHideAllChatJoinRequests withLink(@Nullable String value) {
        if (Objects.equals(this.link, value)) {
            return this;
        }
        return new ImmutableHideAllChatJoinRequests(this.identifier, this.flags, this.approved, this.peer, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableHideAllChatJoinRequests && this.equalTo(0, (ImmutableHideAllChatJoinRequests)another);
    }

    private boolean equalTo(int synthetic, ImmutableHideAllChatJoinRequests another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.approved == another.approved && this.peer.equals(another.peer) && Objects.equals(this.link, another.link);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.approved);
        h += (h << 5) + this.peer.hashCode();
        h += (h << 5) + Objects.hashCode(this.link);
        return h;
    }

    public String toString() {
        return "HideAllChatJoinRequests{identifier=" + this.identifier + ", flags=" + this.flags + ", approved=" + this.approved + ", peer=" + this.peer + ", link=" + this.link + "}";
    }

    public static ImmutableHideAllChatJoinRequests of(InputPeer peer) {
        return new ImmutableHideAllChatJoinRequests(peer);
    }

    public static ImmutableHideAllChatJoinRequests copyOf(HideAllChatJoinRequests instance) {
        if (instance instanceof ImmutableHideAllChatJoinRequests) {
            return (ImmutableHideAllChatJoinRequests)instance;
        }
        return ImmutableHideAllChatJoinRequests.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PEER = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_APPROVED = 4L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean approved;
        private InputPeer peer;
        private String link;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(HideAllChatJoinRequests instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof HideAllChatJoinRequests) {
                instance = (HideAllChatJoinRequests)object;
                this.flags(instance.flags());
                String linkValue = instance.link();
                if (linkValue != null) {
                    this.link(linkValue);
                }
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.approved(instance.approved());
                this.peer(instance.peer());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder approved(boolean approved) {
            this.approved = approved;
            this.optBits |= 4L;
            return this;
        }

        public final Builder peer(InputPeer peer) {
            this.peer = Objects.requireNonNull(peer, "peer");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder link(@Nullable String link) {
            this.link = link;
            return this;
        }

        public ImmutableHideAllChatJoinRequests build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableHideAllChatJoinRequests(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean approvedIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("peer");
            }
            return "Cannot build HideAllChatJoinRequests, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte approvedBuildStage = 0;
        private boolean approved;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableHideAllChatJoinRequests.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableHideAllChatJoinRequests.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean approved() {
            if (this.approvedBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.approvedBuildStage == 0) {
                this.approvedBuildStage = (byte)-1;
                this.approved = ImmutableHideAllChatJoinRequests.this.approvedInitialize();
                this.approvedBuildStage = 1;
            }
            return this.approved;
        }

        void approved(boolean approved) {
            this.approved = approved;
            this.approvedBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.approvedBuildStage == -1) {
                attributes.add("approved");
            }
            return "Cannot build HideAllChatJoinRequests, attribute initializers form cycle " + attributes;
        }
    }
}

