/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.messages;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputPeer;
import telegram4j.tl.InputUser;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.messages.HideChatJoinRequest;

public final class ImmutableHideChatJoinRequest
implements HideChatJoinRequest {
    private final int identifier;
    private final int flags;
    private final boolean approved;
    private final InputPeer peer;
    private final InputUser userId;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableHideChatJoinRequest(InputPeer peer, InputUser userId) {
        this.peer = Objects.requireNonNull(peer, "peer");
        this.userId = Objects.requireNonNull(userId, "userId");
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.approved = this.initShim.approved();
        this.initShim = null;
    }

    private ImmutableHideChatJoinRequest(Builder builder) {
        this.peer = builder.peer;
        this.userId = builder.userId;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.approvedIsSet()) {
            this.initShim.approved(builder.approved);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.approved = this.initShim.approved();
        this.initShim = null;
    }

    private ImmutableHideChatJoinRequest(int identifier, int flags, boolean approved, InputPeer peer, InputUser userId) {
        this.identifier = identifier;
        this.flags = flags;
        this.approved = approved;
        this.peer = peer;
        this.userId = userId;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return HideChatJoinRequest.super.identifier();
    }

    private int flagsInitialize() {
        return HideChatJoinRequest.super.flags();
    }

    private boolean approvedInitialize() {
        return HideChatJoinRequest.super.approved();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean approved() {
        InitShim shim = this.initShim;
        return shim != null ? shim.approved() : this.approved;
    }

    @Override
    public InputPeer peer() {
        return this.peer;
    }

    @Override
    public InputUser userId() {
        return this.userId;
    }

    public final ImmutableHideChatJoinRequest withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableHideChatJoinRequest(value, this.flags, this.approved, this.peer, this.userId);
    }

    public final ImmutableHideChatJoinRequest withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableHideChatJoinRequest(this.identifier, value, this.approved, this.peer, this.userId);
    }

    public final ImmutableHideChatJoinRequest withApproved(boolean value) {
        if (this.approved == value) {
            return this;
        }
        return new ImmutableHideChatJoinRequest(this.identifier, this.flags, value, this.peer, this.userId);
    }

    public final ImmutableHideChatJoinRequest withPeer(InputPeer value) {
        if (this.peer == value) {
            return this;
        }
        InputPeer newValue = Objects.requireNonNull(value, "peer");
        return new ImmutableHideChatJoinRequest(this.identifier, this.flags, this.approved, newValue, this.userId);
    }

    public final ImmutableHideChatJoinRequest withUserId(InputUser value) {
        if (this.userId == value) {
            return this;
        }
        InputUser newValue = Objects.requireNonNull(value, "userId");
        return new ImmutableHideChatJoinRequest(this.identifier, this.flags, this.approved, this.peer, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableHideChatJoinRequest && this.equalTo(0, (ImmutableHideChatJoinRequest)another);
    }

    private boolean equalTo(int synthetic, ImmutableHideChatJoinRequest another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.approved == another.approved && this.peer.equals(another.peer) && this.userId.equals(another.userId);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.approved);
        h += (h << 5) + this.peer.hashCode();
        h += (h << 5) + this.userId.hashCode();
        return h;
    }

    public String toString() {
        return "HideChatJoinRequest{identifier=" + this.identifier + ", flags=" + this.flags + ", approved=" + this.approved + ", peer=" + this.peer + ", userId=" + this.userId + "}";
    }

    public static ImmutableHideChatJoinRequest of(InputPeer peer, InputUser userId) {
        return new ImmutableHideChatJoinRequest(peer, userId);
    }

    public static ImmutableHideChatJoinRequest copyOf(HideChatJoinRequest instance) {
        if (instance instanceof ImmutableHideChatJoinRequest) {
            return (ImmutableHideChatJoinRequest)instance;
        }
        return ImmutableHideChatJoinRequest.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PEER = 1L;
        private static final long INIT_BIT_USER_ID = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_APPROVED = 4L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean approved;
        private InputPeer peer;
        private InputUser userId;

        private Builder() {
        }

        public final Builder from(HideChatJoinRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            HideChatJoinRequest instance;
            long bits = 0L;
            if (object instanceof HideChatJoinRequest) {
                instance = (HideChatJoinRequest)object;
                this.flags(instance.flags());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.approved(instance.approved());
                this.userId(instance.userId());
                this.peer(instance.peer());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder approved(boolean approved) {
            this.approved = approved;
            this.optBits |= 4L;
            return this;
        }

        public final Builder peer(InputPeer peer) {
            this.peer = Objects.requireNonNull(peer, "peer");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder userId(InputUser userId) {
            this.userId = Objects.requireNonNull(userId, "userId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableHideChatJoinRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableHideChatJoinRequest(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean approvedIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("peer");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("userId");
            }
            return "Cannot build HideChatJoinRequest, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte approvedBuildStage = 0;
        private boolean approved;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableHideChatJoinRequest.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableHideChatJoinRequest.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean approved() {
            if (this.approvedBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.approvedBuildStage == 0) {
                this.approvedBuildStage = (byte)-1;
                this.approved = ImmutableHideChatJoinRequest.this.approvedInitialize();
                this.approvedBuildStage = 1;
            }
            return this.approved;
        }

        void approved(boolean approved) {
            this.approved = approved;
            this.approvedBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.approvedBuildStage == -1) {
                attributes.add("approved");
            }
            return "Cannot build HideChatJoinRequest, attribute initializers form cycle " + attributes;
        }
    }
}

