/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.messages;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputFile;
import telegram4j.tl.InputPeer;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.messages.InitHistoryImport;

public final class ImmutableInitHistoryImport
implements InitHistoryImport {
    private final int identifier;
    private final InputPeer peer;
    private final InputFile file;
    private final int mediaCount;

    private ImmutableInitHistoryImport(InputPeer peer, InputFile file, int mediaCount) {
        this.peer = Objects.requireNonNull(peer, "peer");
        this.file = Objects.requireNonNull(file, "file");
        this.mediaCount = mediaCount;
        this.identifier = InitHistoryImport.super.identifier();
    }

    private ImmutableInitHistoryImport(Builder builder) {
        this.peer = builder.peer;
        this.file = builder.file;
        this.mediaCount = builder.mediaCount;
        this.identifier = builder.identifierIsSet() ? builder.identifier : InitHistoryImport.super.identifier();
    }

    private ImmutableInitHistoryImport(int identifier, InputPeer peer, InputFile file, int mediaCount) {
        this.identifier = identifier;
        this.peer = peer;
        this.file = file;
        this.mediaCount = mediaCount;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public InputPeer peer() {
        return this.peer;
    }

    @Override
    public InputFile file() {
        return this.file;
    }

    @Override
    public int mediaCount() {
        return this.mediaCount;
    }

    public final ImmutableInitHistoryImport withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableInitHistoryImport(value, this.peer, this.file, this.mediaCount);
    }

    public final ImmutableInitHistoryImport withPeer(InputPeer value) {
        if (this.peer == value) {
            return this;
        }
        InputPeer newValue = Objects.requireNonNull(value, "peer");
        return new ImmutableInitHistoryImport(this.identifier, newValue, this.file, this.mediaCount);
    }

    public final ImmutableInitHistoryImport withFile(InputFile value) {
        if (this.file == value) {
            return this;
        }
        InputFile newValue = Objects.requireNonNull(value, "file");
        return new ImmutableInitHistoryImport(this.identifier, this.peer, newValue, this.mediaCount);
    }

    public final ImmutableInitHistoryImport withMediaCount(int value) {
        if (this.mediaCount == value) {
            return this;
        }
        return new ImmutableInitHistoryImport(this.identifier, this.peer, this.file, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableInitHistoryImport && this.equalTo(0, (ImmutableInitHistoryImport)another);
    }

    private boolean equalTo(int synthetic, ImmutableInitHistoryImport another) {
        return this.identifier == another.identifier && this.peer.equals(another.peer) && this.file.equals(another.file) && this.mediaCount == another.mediaCount;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.peer.hashCode();
        h += (h << 5) + this.file.hashCode();
        h += (h << 5) + this.mediaCount;
        return h;
    }

    public String toString() {
        return "InitHistoryImport{identifier=" + this.identifier + ", peer=" + this.peer + ", file=" + this.file + ", mediaCount=" + this.mediaCount + "}";
    }

    public static ImmutableInitHistoryImport of(InputPeer peer, InputFile file, int mediaCount) {
        return new ImmutableInitHistoryImport(peer, file, mediaCount);
    }

    public static ImmutableInitHistoryImport copyOf(InitHistoryImport instance) {
        if (instance instanceof ImmutableInitHistoryImport) {
            return (ImmutableInitHistoryImport)instance;
        }
        return ImmutableInitHistoryImport.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PEER = 1L;
        private static final long INIT_BIT_FILE = 2L;
        private static final long INIT_BIT_MEDIA_COUNT = 4L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 7L;
        private long optBits;
        private int identifier;
        private InputPeer peer;
        private InputFile file;
        private int mediaCount;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(InitHistoryImport instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof InitHistoryImport) {
                instance = (InitHistoryImport)object;
                this.mediaCount(instance.mediaCount());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.file(instance.file());
                this.peer(instance.peer());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder peer(InputPeer peer) {
            this.peer = Objects.requireNonNull(peer, "peer");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder file(InputFile file) {
            this.file = Objects.requireNonNull(file, "file");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder mediaCount(int mediaCount) {
            this.mediaCount = mediaCount;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableInitHistoryImport build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableInitHistoryImport(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("peer");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("file");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("mediaCount");
            }
            return "Cannot build InitHistoryImport, some of required attributes are not set " + attributes;
        }
    }
}

