/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.messages;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputStickerSet;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.messages.InstallStickerSet;

public final class ImmutableInstallStickerSet
implements InstallStickerSet {
    private final int identifier;
    private final InputStickerSet stickerset;
    private final boolean archived;

    private ImmutableInstallStickerSet(InputStickerSet stickerset, boolean archived) {
        this.stickerset = Objects.requireNonNull(stickerset, "stickerset");
        this.archived = archived;
        this.identifier = InstallStickerSet.super.identifier();
    }

    private ImmutableInstallStickerSet(Builder builder) {
        this.stickerset = builder.stickerset;
        this.archived = builder.archived;
        this.identifier = builder.identifierIsSet() ? builder.identifier : InstallStickerSet.super.identifier();
    }

    private ImmutableInstallStickerSet(int identifier, InputStickerSet stickerset, boolean archived) {
        this.identifier = identifier;
        this.stickerset = stickerset;
        this.archived = archived;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public InputStickerSet stickerset() {
        return this.stickerset;
    }

    @Override
    public boolean archived() {
        return this.archived;
    }

    public final ImmutableInstallStickerSet withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableInstallStickerSet(value, this.stickerset, this.archived);
    }

    public final ImmutableInstallStickerSet withStickerset(InputStickerSet value) {
        if (this.stickerset == value) {
            return this;
        }
        InputStickerSet newValue = Objects.requireNonNull(value, "stickerset");
        return new ImmutableInstallStickerSet(this.identifier, newValue, this.archived);
    }

    public final ImmutableInstallStickerSet withArchived(boolean value) {
        if (this.archived == value) {
            return this;
        }
        return new ImmutableInstallStickerSet(this.identifier, this.stickerset, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableInstallStickerSet && this.equalTo(0, (ImmutableInstallStickerSet)another);
    }

    private boolean equalTo(int synthetic, ImmutableInstallStickerSet another) {
        return this.identifier == another.identifier && this.stickerset.equals(another.stickerset) && this.archived == another.archived;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.stickerset.hashCode();
        h += (h << 5) + Boolean.hashCode(this.archived);
        return h;
    }

    public String toString() {
        return "InstallStickerSet{identifier=" + this.identifier + ", stickerset=" + this.stickerset + ", archived=" + this.archived + "}";
    }

    public static ImmutableInstallStickerSet of(InputStickerSet stickerset, boolean archived) {
        return new ImmutableInstallStickerSet(stickerset, archived);
    }

    public static ImmutableInstallStickerSet copyOf(InstallStickerSet instance) {
        if (instance instanceof ImmutableInstallStickerSet) {
            return (ImmutableInstallStickerSet)instance;
        }
        return ImmutableInstallStickerSet.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_STICKERSET = 1L;
        private static final long INIT_BIT_ARCHIVED = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private InputStickerSet stickerset;
        private boolean archived;

        private Builder() {
        }

        public final Builder from(InstallStickerSet instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            InstallStickerSet instance;
            long bits = 0L;
            if (object instanceof InstallStickerSet) {
                instance = (InstallStickerSet)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.archived(instance.archived());
                this.stickerset(instance.stickerset());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder stickerset(InputStickerSet stickerset) {
            this.stickerset = Objects.requireNonNull(stickerset, "stickerset");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder archived(boolean archived) {
            this.archived = archived;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableInstallStickerSet build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableInstallStickerSet(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("stickerset");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("archived");
            }
            return "Cannot build InstallStickerSet, some of required attributes are not set " + attributes;
        }
    }
}

