/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.messages;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputDialogPeer;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.messages.MarkDialogUnread;

public final class ImmutableMarkDialogUnread
implements MarkDialogUnread {
    private final int identifier;
    private final int flags;
    private final boolean unread;
    private final InputDialogPeer peer;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableMarkDialogUnread(InputDialogPeer peer) {
        this.peer = Objects.requireNonNull(peer, "peer");
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.unread = this.initShim.unread();
        this.initShim = null;
    }

    private ImmutableMarkDialogUnread(Builder builder) {
        this.peer = builder.peer;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.unreadIsSet()) {
            this.initShim.unread(builder.unread);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.unread = this.initShim.unread();
        this.initShim = null;
    }

    private ImmutableMarkDialogUnread(int identifier, int flags, boolean unread, InputDialogPeer peer) {
        this.identifier = identifier;
        this.flags = flags;
        this.unread = unread;
        this.peer = peer;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return MarkDialogUnread.super.identifier();
    }

    private int flagsInitialize() {
        return MarkDialogUnread.super.flags();
    }

    private boolean unreadInitialize() {
        return MarkDialogUnread.super.unread();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean unread() {
        InitShim shim = this.initShim;
        return shim != null ? shim.unread() : this.unread;
    }

    @Override
    public InputDialogPeer peer() {
        return this.peer;
    }

    public final ImmutableMarkDialogUnread withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableMarkDialogUnread(value, this.flags, this.unread, this.peer);
    }

    public final ImmutableMarkDialogUnread withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableMarkDialogUnread(this.identifier, value, this.unread, this.peer);
    }

    public final ImmutableMarkDialogUnread withUnread(boolean value) {
        if (this.unread == value) {
            return this;
        }
        return new ImmutableMarkDialogUnread(this.identifier, this.flags, value, this.peer);
    }

    public final ImmutableMarkDialogUnread withPeer(InputDialogPeer value) {
        if (this.peer == value) {
            return this;
        }
        InputDialogPeer newValue = Objects.requireNonNull(value, "peer");
        return new ImmutableMarkDialogUnread(this.identifier, this.flags, this.unread, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMarkDialogUnread && this.equalTo(0, (ImmutableMarkDialogUnread)another);
    }

    private boolean equalTo(int synthetic, ImmutableMarkDialogUnread another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.unread == another.unread && this.peer.equals(another.peer);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.unread);
        h += (h << 5) + this.peer.hashCode();
        return h;
    }

    public String toString() {
        return "MarkDialogUnread{identifier=" + this.identifier + ", flags=" + this.flags + ", unread=" + this.unread + ", peer=" + this.peer + "}";
    }

    public static ImmutableMarkDialogUnread of(InputDialogPeer peer) {
        return new ImmutableMarkDialogUnread(peer);
    }

    public static ImmutableMarkDialogUnread copyOf(MarkDialogUnread instance) {
        if (instance instanceof ImmutableMarkDialogUnread) {
            return (ImmutableMarkDialogUnread)instance;
        }
        return ImmutableMarkDialogUnread.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PEER = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_UNREAD = 4L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean unread;
        private InputDialogPeer peer;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(MarkDialogUnread instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof MarkDialogUnread) {
                instance = (MarkDialogUnread)object;
                this.flags(instance.flags());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.unread(instance.unread());
                this.peer(instance.peer());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder unread(boolean unread) {
            this.unread = unread;
            this.optBits |= 4L;
            return this;
        }

        public final Builder peer(InputDialogPeer peer) {
            this.peer = Objects.requireNonNull(peer, "peer");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableMarkDialogUnread build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableMarkDialogUnread(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean unreadIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("peer");
            }
            return "Cannot build MarkDialogUnread, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte unreadBuildStage = 0;
        private boolean unread;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableMarkDialogUnread.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableMarkDialogUnread.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean unread() {
            if (this.unreadBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.unreadBuildStage == 0) {
                this.unreadBuildStage = (byte)-1;
                this.unread = ImmutableMarkDialogUnread.this.unreadInitialize();
                this.unreadBuildStage = 1;
            }
            return this.unread;
        }

        void unread(boolean unread) {
            this.unread = unread;
            this.unreadBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.unreadBuildStage == -1) {
                attributes.add("unread");
            }
            return "Cannot build MarkDialogUnread, attribute initializers form cycle " + attributes;
        }
    }
}

