/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.messages;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.messages.MigrateChat;

public final class ImmutableMigrateChat
implements MigrateChat {
    private final int identifier;
    private final long chatId;

    private ImmutableMigrateChat(long chatId) {
        this.chatId = chatId;
        this.identifier = MigrateChat.super.identifier();
    }

    private ImmutableMigrateChat(Builder builder) {
        this.chatId = builder.chatId;
        this.identifier = builder.identifierIsSet() ? builder.identifier : MigrateChat.super.identifier();
    }

    private ImmutableMigrateChat(int identifier, long chatId) {
        this.identifier = identifier;
        this.chatId = chatId;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public long chatId() {
        return this.chatId;
    }

    public final ImmutableMigrateChat withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableMigrateChat(value, this.chatId);
    }

    public final ImmutableMigrateChat withChatId(long value) {
        if (this.chatId == value) {
            return this;
        }
        return new ImmutableMigrateChat(this.identifier, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMigrateChat && this.equalTo(0, (ImmutableMigrateChat)another);
    }

    private boolean equalTo(int synthetic, ImmutableMigrateChat another) {
        return this.identifier == another.identifier && this.chatId == another.chatId;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + Long.hashCode(this.chatId);
        return h;
    }

    public String toString() {
        return "MigrateChat{identifier=" + this.identifier + ", chatId=" + this.chatId + "}";
    }

    public static ImmutableMigrateChat of(long chatId) {
        return new ImmutableMigrateChat(chatId);
    }

    public static ImmutableMigrateChat copyOf(MigrateChat instance) {
        if (instance instanceof ImmutableMigrateChat) {
            return (ImmutableMigrateChat)instance;
        }
        return ImmutableMigrateChat.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_CHAT_ID = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private long chatId;

        private Builder() {
        }

        public final Builder from(MigrateChat instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            MigrateChat instance;
            long bits = 0L;
            if (object instanceof MigrateChat) {
                instance = (MigrateChat)object;
                this.chatId(instance.chatId());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder chatId(long chatId) {
            this.chatId = chatId;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableMigrateChat build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableMigrateChat(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("chatId");
            }
            return "Cannot build MigrateChat, some of required attributes are not set " + attributes;
        }
    }
}

