/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.messages;

import java.util.ArrayList;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.InputPeer;
import telegram4j.tl.InputUser;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.messages.ProlongWebView;

public final class ImmutableProlongWebView
implements ProlongWebView {
    private final int identifier;
    private final int flags;
    private final boolean silent;
    private final InputPeer peer;
    private final InputUser bot;
    private final long queryId;
    @Nullable
    private final Integer replyToMsgId;
    @Nullable
    private final InputPeer sendAs;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableProlongWebView(InputPeer peer, InputUser bot, long queryId) {
        this.peer = Objects.requireNonNull(peer, "peer");
        this.bot = Objects.requireNonNull(bot, "bot");
        this.queryId = queryId;
        this.replyToMsgId = null;
        this.sendAs = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.silent = this.initShim.silent();
        this.initShim = null;
    }

    private ImmutableProlongWebView(Builder builder) {
        this.peer = builder.peer;
        this.bot = builder.bot;
        this.queryId = builder.queryId;
        this.replyToMsgId = builder.replyToMsgId;
        this.sendAs = builder.sendAs;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.silentIsSet()) {
            this.initShim.silent(builder.silent);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.silent = this.initShim.silent();
        this.initShim = null;
    }

    private ImmutableProlongWebView(int identifier, int flags, boolean silent, InputPeer peer, InputUser bot, long queryId, @Nullable Integer replyToMsgId, @Nullable InputPeer sendAs) {
        this.identifier = identifier;
        this.flags = flags;
        this.silent = silent;
        this.peer = peer;
        this.bot = bot;
        this.queryId = queryId;
        this.replyToMsgId = replyToMsgId;
        this.sendAs = sendAs;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return ProlongWebView.super.identifier();
    }

    private int flagsInitialize() {
        return ProlongWebView.super.flags();
    }

    private boolean silentInitialize() {
        return ProlongWebView.super.silent();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean silent() {
        InitShim shim = this.initShim;
        return shim != null ? shim.silent() : this.silent;
    }

    @Override
    public InputPeer peer() {
        return this.peer;
    }

    @Override
    public InputUser bot() {
        return this.bot;
    }

    @Override
    public long queryId() {
        return this.queryId;
    }

    @Override
    @Nullable
    public Integer replyToMsgId() {
        return this.replyToMsgId;
    }

    @Override
    @Nullable
    public InputPeer sendAs() {
        return this.sendAs;
    }

    public final ImmutableProlongWebView withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableProlongWebView(value, this.flags, this.silent, this.peer, this.bot, this.queryId, this.replyToMsgId, this.sendAs);
    }

    public final ImmutableProlongWebView withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableProlongWebView(this.identifier, value, this.silent, this.peer, this.bot, this.queryId, this.replyToMsgId, this.sendAs);
    }

    public final ImmutableProlongWebView withSilent(boolean value) {
        if (this.silent == value) {
            return this;
        }
        return new ImmutableProlongWebView(this.identifier, this.flags, value, this.peer, this.bot, this.queryId, this.replyToMsgId, this.sendAs);
    }

    public final ImmutableProlongWebView withPeer(InputPeer value) {
        if (this.peer == value) {
            return this;
        }
        InputPeer newValue = Objects.requireNonNull(value, "peer");
        return new ImmutableProlongWebView(this.identifier, this.flags, this.silent, newValue, this.bot, this.queryId, this.replyToMsgId, this.sendAs);
    }

    public final ImmutableProlongWebView withBot(InputUser value) {
        if (this.bot == value) {
            return this;
        }
        InputUser newValue = Objects.requireNonNull(value, "bot");
        return new ImmutableProlongWebView(this.identifier, this.flags, this.silent, this.peer, newValue, this.queryId, this.replyToMsgId, this.sendAs);
    }

    public final ImmutableProlongWebView withQueryId(long value) {
        if (this.queryId == value) {
            return this;
        }
        return new ImmutableProlongWebView(this.identifier, this.flags, this.silent, this.peer, this.bot, value, this.replyToMsgId, this.sendAs);
    }

    public final ImmutableProlongWebView withReplyToMsgId(@Nullable Integer value) {
        if (Objects.equals(this.replyToMsgId, value)) {
            return this;
        }
        return new ImmutableProlongWebView(this.identifier, this.flags, this.silent, this.peer, this.bot, this.queryId, value, this.sendAs);
    }

    public final ImmutableProlongWebView withSendAs(@Nullable InputPeer value) {
        if (this.sendAs == value) {
            return this;
        }
        return new ImmutableProlongWebView(this.identifier, this.flags, this.silent, this.peer, this.bot, this.queryId, this.replyToMsgId, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableProlongWebView && this.equalTo(0, (ImmutableProlongWebView)another);
    }

    private boolean equalTo(int synthetic, ImmutableProlongWebView another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.silent == another.silent && this.peer.equals(another.peer) && this.bot.equals(another.bot) && this.queryId == another.queryId && Objects.equals(this.replyToMsgId, another.replyToMsgId) && Objects.equals(this.sendAs, another.sendAs);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.silent);
        h += (h << 5) + this.peer.hashCode();
        h += (h << 5) + this.bot.hashCode();
        h += (h << 5) + Long.hashCode(this.queryId);
        h += (h << 5) + Objects.hashCode(this.replyToMsgId);
        h += (h << 5) + Objects.hashCode(this.sendAs);
        return h;
    }

    public String toString() {
        return "ProlongWebView{identifier=" + this.identifier + ", flags=" + this.flags + ", silent=" + this.silent + ", peer=" + this.peer + ", bot=" + this.bot + ", queryId=" + this.queryId + ", replyToMsgId=" + this.replyToMsgId + ", sendAs=" + this.sendAs + "}";
    }

    public static ImmutableProlongWebView of(InputPeer peer, InputUser bot, long queryId) {
        return new ImmutableProlongWebView(peer, bot, queryId);
    }

    public static ImmutableProlongWebView copyOf(ProlongWebView instance) {
        if (instance instanceof ImmutableProlongWebView) {
            return (ImmutableProlongWebView)instance;
        }
        return ImmutableProlongWebView.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PEER = 1L;
        private static final long INIT_BIT_BOT = 2L;
        private static final long INIT_BIT_QUERY_ID = 4L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_SILENT = 4L;
        private long initBits = 7L;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean silent;
        private InputPeer peer;
        private InputUser bot;
        private long queryId;
        private Integer replyToMsgId;
        private InputPeer sendAs;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ProlongWebView instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof ProlongWebView) {
                Integer replyToMsgIdValue;
                instance = (ProlongWebView)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.silent(instance.silent());
                this.peer(instance.peer());
                this.bot(instance.bot());
                this.flags(instance.flags());
                InputPeer sendAsValue = instance.sendAs();
                if (sendAsValue != null) {
                    this.sendAs(sendAsValue);
                }
                if ((replyToMsgIdValue = instance.replyToMsgId()) != null) {
                    this.replyToMsgId(replyToMsgIdValue);
                }
                this.queryId(instance.queryId());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder silent(boolean silent) {
            this.silent = silent;
            this.optBits |= 4L;
            return this;
        }

        public final Builder peer(InputPeer peer) {
            this.peer = Objects.requireNonNull(peer, "peer");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder bot(InputUser bot) {
            this.bot = Objects.requireNonNull(bot, "bot");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder queryId(long queryId) {
            this.queryId = queryId;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder replyToMsgId(@Nullable Integer replyToMsgId) {
            this.replyToMsgId = replyToMsgId;
            return this;
        }

        public final Builder sendAs(@Nullable InputPeer sendAs) {
            this.sendAs = sendAs;
            return this;
        }

        public ImmutableProlongWebView build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableProlongWebView(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean silentIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("peer");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("bot");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("queryId");
            }
            return "Cannot build ProlongWebView, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte silentBuildStage = 0;
        private boolean silent;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableProlongWebView.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableProlongWebView.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean silent() {
            if (this.silentBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.silentBuildStage == 0) {
                this.silentBuildStage = (byte)-1;
                this.silent = ImmutableProlongWebView.this.silentInitialize();
                this.silentBuildStage = 1;
            }
            return this.silent;
        }

        void silent(boolean silent) {
            this.silent = silent;
            this.silentBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.silentBuildStage == -1) {
                attributes.add("silent");
            }
            return "Cannot build ProlongWebView, attribute initializers form cycle " + attributes;
        }
    }
}

