/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.messages;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputPeer;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.messages.RateTranscribedAudio;

public final class ImmutableRateTranscribedAudio
implements RateTranscribedAudio {
    private final int identifier;
    private final InputPeer peer;
    private final int msgId;
    private final long transcriptionId;
    private final boolean good;

    private ImmutableRateTranscribedAudio(InputPeer peer, int msgId, long transcriptionId, boolean good) {
        this.peer = Objects.requireNonNull(peer, "peer");
        this.msgId = msgId;
        this.transcriptionId = transcriptionId;
        this.good = good;
        this.identifier = RateTranscribedAudio.super.identifier();
    }

    private ImmutableRateTranscribedAudio(Builder builder) {
        this.peer = builder.peer;
        this.msgId = builder.msgId;
        this.transcriptionId = builder.transcriptionId;
        this.good = builder.good;
        this.identifier = builder.identifierIsSet() ? builder.identifier : RateTranscribedAudio.super.identifier();
    }

    private ImmutableRateTranscribedAudio(int identifier, InputPeer peer, int msgId, long transcriptionId, boolean good) {
        this.identifier = identifier;
        this.peer = peer;
        this.msgId = msgId;
        this.transcriptionId = transcriptionId;
        this.good = good;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public InputPeer peer() {
        return this.peer;
    }

    @Override
    public int msgId() {
        return this.msgId;
    }

    @Override
    public long transcriptionId() {
        return this.transcriptionId;
    }

    @Override
    public boolean good() {
        return this.good;
    }

    public final ImmutableRateTranscribedAudio withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableRateTranscribedAudio(value, this.peer, this.msgId, this.transcriptionId, this.good);
    }

    public final ImmutableRateTranscribedAudio withPeer(InputPeer value) {
        if (this.peer == value) {
            return this;
        }
        InputPeer newValue = Objects.requireNonNull(value, "peer");
        return new ImmutableRateTranscribedAudio(this.identifier, newValue, this.msgId, this.transcriptionId, this.good);
    }

    public final ImmutableRateTranscribedAudio withMsgId(int value) {
        if (this.msgId == value) {
            return this;
        }
        return new ImmutableRateTranscribedAudio(this.identifier, this.peer, value, this.transcriptionId, this.good);
    }

    public final ImmutableRateTranscribedAudio withTranscriptionId(long value) {
        if (this.transcriptionId == value) {
            return this;
        }
        return new ImmutableRateTranscribedAudio(this.identifier, this.peer, this.msgId, value, this.good);
    }

    public final ImmutableRateTranscribedAudio withGood(boolean value) {
        if (this.good == value) {
            return this;
        }
        return new ImmutableRateTranscribedAudio(this.identifier, this.peer, this.msgId, this.transcriptionId, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRateTranscribedAudio && this.equalTo(0, (ImmutableRateTranscribedAudio)another);
    }

    private boolean equalTo(int synthetic, ImmutableRateTranscribedAudio another) {
        return this.identifier == another.identifier && this.peer.equals(another.peer) && this.msgId == another.msgId && this.transcriptionId == another.transcriptionId && this.good == another.good;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.peer.hashCode();
        h += (h << 5) + this.msgId;
        h += (h << 5) + Long.hashCode(this.transcriptionId);
        h += (h << 5) + Boolean.hashCode(this.good);
        return h;
    }

    public String toString() {
        return "RateTranscribedAudio{identifier=" + this.identifier + ", peer=" + this.peer + ", msgId=" + this.msgId + ", transcriptionId=" + this.transcriptionId + ", good=" + this.good + "}";
    }

    public static ImmutableRateTranscribedAudio of(InputPeer peer, int msgId, long transcriptionId, boolean good) {
        return new ImmutableRateTranscribedAudio(peer, msgId, transcriptionId, good);
    }

    public static ImmutableRateTranscribedAudio copyOf(RateTranscribedAudio instance) {
        if (instance instanceof ImmutableRateTranscribedAudio) {
            return (ImmutableRateTranscribedAudio)instance;
        }
        return ImmutableRateTranscribedAudio.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PEER = 1L;
        private static final long INIT_BIT_MSG_ID = 2L;
        private static final long INIT_BIT_TRANSCRIPTION_ID = 4L;
        private static final long INIT_BIT_GOOD = 8L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 15L;
        private long optBits;
        private int identifier;
        private InputPeer peer;
        private int msgId;
        private long transcriptionId;
        private boolean good;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(RateTranscribedAudio instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof RateTranscribedAudio) {
                instance = (RateTranscribedAudio)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.msgId(instance.msgId());
                this.good(instance.good());
                this.peer(instance.peer());
                this.transcriptionId(instance.transcriptionId());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder peer(InputPeer peer) {
            this.peer = Objects.requireNonNull(peer, "peer");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder msgId(int msgId) {
            this.msgId = msgId;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder transcriptionId(long transcriptionId) {
            this.transcriptionId = transcriptionId;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder good(boolean good) {
            this.good = good;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public ImmutableRateTranscribedAudio build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableRateTranscribedAudio(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("peer");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("msgId");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("transcriptionId");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("good");
            }
            return "Cannot build RateTranscribedAudio, some of required attributes are not set " + attributes;
        }
    }
}

