/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.messages;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputPeer;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.messages.ReadDiscussion;

public final class ImmutableReadDiscussion
implements ReadDiscussion {
    private final int identifier;
    private final InputPeer peer;
    private final int msgId;
    private final int readMaxId;

    private ImmutableReadDiscussion(InputPeer peer, int msgId, int readMaxId) {
        this.peer = Objects.requireNonNull(peer, "peer");
        this.msgId = msgId;
        this.readMaxId = readMaxId;
        this.identifier = ReadDiscussion.super.identifier();
    }

    private ImmutableReadDiscussion(Builder builder) {
        this.peer = builder.peer;
        this.msgId = builder.msgId;
        this.readMaxId = builder.readMaxId;
        this.identifier = builder.identifierIsSet() ? builder.identifier : ReadDiscussion.super.identifier();
    }

    private ImmutableReadDiscussion(int identifier, InputPeer peer, int msgId, int readMaxId) {
        this.identifier = identifier;
        this.peer = peer;
        this.msgId = msgId;
        this.readMaxId = readMaxId;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public InputPeer peer() {
        return this.peer;
    }

    @Override
    public int msgId() {
        return this.msgId;
    }

    @Override
    public int readMaxId() {
        return this.readMaxId;
    }

    public final ImmutableReadDiscussion withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableReadDiscussion(value, this.peer, this.msgId, this.readMaxId);
    }

    public final ImmutableReadDiscussion withPeer(InputPeer value) {
        if (this.peer == value) {
            return this;
        }
        InputPeer newValue = Objects.requireNonNull(value, "peer");
        return new ImmutableReadDiscussion(this.identifier, newValue, this.msgId, this.readMaxId);
    }

    public final ImmutableReadDiscussion withMsgId(int value) {
        if (this.msgId == value) {
            return this;
        }
        return new ImmutableReadDiscussion(this.identifier, this.peer, value, this.readMaxId);
    }

    public final ImmutableReadDiscussion withReadMaxId(int value) {
        if (this.readMaxId == value) {
            return this;
        }
        return new ImmutableReadDiscussion(this.identifier, this.peer, this.msgId, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableReadDiscussion && this.equalTo(0, (ImmutableReadDiscussion)another);
    }

    private boolean equalTo(int synthetic, ImmutableReadDiscussion another) {
        return this.identifier == another.identifier && this.peer.equals(another.peer) && this.msgId == another.msgId && this.readMaxId == another.readMaxId;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.peer.hashCode();
        h += (h << 5) + this.msgId;
        h += (h << 5) + this.readMaxId;
        return h;
    }

    public String toString() {
        return "ReadDiscussion{identifier=" + this.identifier + ", peer=" + this.peer + ", msgId=" + this.msgId + ", readMaxId=" + this.readMaxId + "}";
    }

    public static ImmutableReadDiscussion of(InputPeer peer, int msgId, int readMaxId) {
        return new ImmutableReadDiscussion(peer, msgId, readMaxId);
    }

    public static ImmutableReadDiscussion copyOf(ReadDiscussion instance) {
        if (instance instanceof ImmutableReadDiscussion) {
            return (ImmutableReadDiscussion)instance;
        }
        return ImmutableReadDiscussion.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PEER = 1L;
        private static final long INIT_BIT_MSG_ID = 2L;
        private static final long INIT_BIT_READ_MAX_ID = 4L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 7L;
        private long optBits;
        private int identifier;
        private InputPeer peer;
        private int msgId;
        private int readMaxId;

        private Builder() {
        }

        public final Builder from(ReadDiscussion instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            ReadDiscussion instance;
            long bits = 0L;
            if (object instanceof ReadDiscussion) {
                instance = (ReadDiscussion)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.msgId(instance.msgId());
                this.readMaxId(instance.readMaxId());
                this.peer(instance.peer());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder peer(InputPeer peer) {
            this.peer = Objects.requireNonNull(peer, "peer");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder msgId(int msgId) {
            this.msgId = msgId;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder readMaxId(int readMaxId) {
            this.readMaxId = readMaxId;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableReadDiscussion build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableReadDiscussion(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("peer");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("msgId");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("readMaxId");
            }
            return "Cannot build ReadDiscussion, some of required attributes are not set " + attributes;
        }
    }
}

