/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.messages;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputEncryptedChat;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.messages.ReadEncryptedHistory;

public final class ImmutableReadEncryptedHistory
implements ReadEncryptedHistory {
    private final int identifier;
    private final InputEncryptedChat peer;
    private final int maxDate;

    private ImmutableReadEncryptedHistory(InputEncryptedChat peer, int maxDate) {
        this.peer = Objects.requireNonNull(peer, "peer");
        this.maxDate = maxDate;
        this.identifier = ReadEncryptedHistory.super.identifier();
    }

    private ImmutableReadEncryptedHistory(Builder builder) {
        this.peer = builder.peer;
        this.maxDate = builder.maxDate;
        this.identifier = builder.identifierIsSet() ? builder.identifier : ReadEncryptedHistory.super.identifier();
    }

    private ImmutableReadEncryptedHistory(int identifier, InputEncryptedChat peer, int maxDate) {
        this.identifier = identifier;
        this.peer = peer;
        this.maxDate = maxDate;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public InputEncryptedChat peer() {
        return this.peer;
    }

    @Override
    public int maxDate() {
        return this.maxDate;
    }

    public final ImmutableReadEncryptedHistory withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableReadEncryptedHistory(value, this.peer, this.maxDate);
    }

    public final ImmutableReadEncryptedHistory withPeer(InputEncryptedChat value) {
        if (this.peer == value) {
            return this;
        }
        InputEncryptedChat newValue = Objects.requireNonNull(value, "peer");
        return new ImmutableReadEncryptedHistory(this.identifier, newValue, this.maxDate);
    }

    public final ImmutableReadEncryptedHistory withMaxDate(int value) {
        if (this.maxDate == value) {
            return this;
        }
        return new ImmutableReadEncryptedHistory(this.identifier, this.peer, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableReadEncryptedHistory && this.equalTo(0, (ImmutableReadEncryptedHistory)another);
    }

    private boolean equalTo(int synthetic, ImmutableReadEncryptedHistory another) {
        return this.identifier == another.identifier && this.peer.equals(another.peer) && this.maxDate == another.maxDate;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.peer.hashCode();
        h += (h << 5) + this.maxDate;
        return h;
    }

    public String toString() {
        return "ReadEncryptedHistory{identifier=" + this.identifier + ", peer=" + this.peer + ", maxDate=" + this.maxDate + "}";
    }

    public static ImmutableReadEncryptedHistory of(InputEncryptedChat peer, int maxDate) {
        return new ImmutableReadEncryptedHistory(peer, maxDate);
    }

    public static ImmutableReadEncryptedHistory copyOf(ReadEncryptedHistory instance) {
        if (instance instanceof ImmutableReadEncryptedHistory) {
            return (ImmutableReadEncryptedHistory)instance;
        }
        return ImmutableReadEncryptedHistory.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PEER = 1L;
        private static final long INIT_BIT_MAX_DATE = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private InputEncryptedChat peer;
        private int maxDate;

        private Builder() {
        }

        public final Builder from(ReadEncryptedHistory instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            ReadEncryptedHistory instance;
            long bits = 0L;
            if (object instanceof ReadEncryptedHistory) {
                instance = (ReadEncryptedHistory)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.peer(instance.peer());
                this.maxDate(instance.maxDate());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder peer(InputEncryptedChat peer) {
            this.peer = Objects.requireNonNull(peer, "peer");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder maxDate(int maxDate) {
            this.maxDate = maxDate;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableReadEncryptedHistory build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableReadEncryptedHistory(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("peer");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("maxDate");
            }
            return "Cannot build ReadEncryptedHistory, some of required attributes are not set " + attributes;
        }
    }
}

