/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.messages;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputPeer;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.messages.ReadHistory;

public final class ImmutableReadHistory
implements ReadHistory {
    private final int identifier;
    private final InputPeer peer;
    private final int maxId;

    private ImmutableReadHistory(InputPeer peer, int maxId) {
        this.peer = Objects.requireNonNull(peer, "peer");
        this.maxId = maxId;
        this.identifier = ReadHistory.super.identifier();
    }

    private ImmutableReadHistory(Builder builder) {
        this.peer = builder.peer;
        this.maxId = builder.maxId;
        this.identifier = builder.identifierIsSet() ? builder.identifier : ReadHistory.super.identifier();
    }

    private ImmutableReadHistory(int identifier, InputPeer peer, int maxId) {
        this.identifier = identifier;
        this.peer = peer;
        this.maxId = maxId;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public InputPeer peer() {
        return this.peer;
    }

    @Override
    public int maxId() {
        return this.maxId;
    }

    public final ImmutableReadHistory withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableReadHistory(value, this.peer, this.maxId);
    }

    public final ImmutableReadHistory withPeer(InputPeer value) {
        if (this.peer == value) {
            return this;
        }
        InputPeer newValue = Objects.requireNonNull(value, "peer");
        return new ImmutableReadHistory(this.identifier, newValue, this.maxId);
    }

    public final ImmutableReadHistory withMaxId(int value) {
        if (this.maxId == value) {
            return this;
        }
        return new ImmutableReadHistory(this.identifier, this.peer, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableReadHistory && this.equalTo(0, (ImmutableReadHistory)another);
    }

    private boolean equalTo(int synthetic, ImmutableReadHistory another) {
        return this.identifier == another.identifier && this.peer.equals(another.peer) && this.maxId == another.maxId;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.peer.hashCode();
        h += (h << 5) + this.maxId;
        return h;
    }

    public String toString() {
        return "ReadHistory{identifier=" + this.identifier + ", peer=" + this.peer + ", maxId=" + this.maxId + "}";
    }

    public static ImmutableReadHistory of(InputPeer peer, int maxId) {
        return new ImmutableReadHistory(peer, maxId);
    }

    public static ImmutableReadHistory copyOf(ReadHistory instance) {
        if (instance instanceof ImmutableReadHistory) {
            return (ImmutableReadHistory)instance;
        }
        return ImmutableReadHistory.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PEER = 1L;
        private static final long INIT_BIT_MAX_ID = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private InputPeer peer;
        private int maxId;

        private Builder() {
        }

        public final Builder from(ReadHistory instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            ReadHistory instance;
            long bits = 0L;
            if (object instanceof ReadHistory) {
                instance = (ReadHistory)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.maxId(instance.maxId());
                this.peer(instance.peer());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder peer(InputPeer peer) {
            this.peer = Objects.requireNonNull(peer, "peer");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder maxId(int maxId) {
            this.maxId = maxId;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableReadHistory build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableReadHistory(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("peer");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("maxId");
            }
            return "Cannot build ReadHistory, some of required attributes are not set " + attributes;
        }
    }
}

