/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.messages;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputPeer;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.messages.ReadMentions;

public final class ImmutableReadMentions
implements ReadMentions {
    private final int identifier;
    private final InputPeer peer;

    private ImmutableReadMentions(InputPeer peer) {
        this.peer = Objects.requireNonNull(peer, "peer");
        this.identifier = ReadMentions.super.identifier();
    }

    private ImmutableReadMentions(Builder builder) {
        this.peer = builder.peer;
        this.identifier = builder.identifierIsSet() ? builder.identifier : ReadMentions.super.identifier();
    }

    private ImmutableReadMentions(int identifier, InputPeer peer) {
        this.identifier = identifier;
        this.peer = peer;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public InputPeer peer() {
        return this.peer;
    }

    public final ImmutableReadMentions withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableReadMentions(value, this.peer);
    }

    public final ImmutableReadMentions withPeer(InputPeer value) {
        if (this.peer == value) {
            return this;
        }
        InputPeer newValue = Objects.requireNonNull(value, "peer");
        return new ImmutableReadMentions(this.identifier, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableReadMentions && this.equalTo(0, (ImmutableReadMentions)another);
    }

    private boolean equalTo(int synthetic, ImmutableReadMentions another) {
        return this.identifier == another.identifier && this.peer.equals(another.peer);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.peer.hashCode();
        return h;
    }

    public String toString() {
        return "ReadMentions{identifier=" + this.identifier + ", peer=" + this.peer + "}";
    }

    public static ImmutableReadMentions of(InputPeer peer) {
        return new ImmutableReadMentions(peer);
    }

    public static ImmutableReadMentions copyOf(ReadMentions instance) {
        if (instance instanceof ImmutableReadMentions) {
            return (ImmutableReadMentions)instance;
        }
        return ImmutableReadMentions.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PEER = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private InputPeer peer;

        private Builder() {
        }

        public final Builder from(ReadMentions instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            ReadMentions instance;
            long bits = 0L;
            if (object instanceof ReadMentions) {
                instance = (ReadMentions)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.peer(instance.peer());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder peer(InputPeer peer) {
            this.peer = Objects.requireNonNull(peer, "peer");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableReadMentions build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableReadMentions(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("peer");
            }
            return "Cannot build ReadMentions, some of required attributes are not set " + attributes;
        }
    }
}

